/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.sql.DatabaseMetaData;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.database.oracle.OracleConfigurationExtension;
import org.flywaydb.database.postgresql.PostgreSQLConfigurationExtension;
import org.flywaydb.database.sqlserver.SQLServerConfigurationExtension;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayConnectionDetails;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywaySchemaManagementProvider;
import org.springframework.boot.autoconfigure.flyway.ResourceProviderCustomizer;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@ConditionalOnClass(value={Flyway.class})
@Conditional(value={FlywayDataSourceCondition.class})
@ConditionalOnBooleanProperty(name={"spring.flyway.enabled"}, matchIfMissing=true)
@Import(value={DatabaseInitializationDependencyConfigurer.class})
@ImportRuntimeHints(value={FlywayAutoConfigurationRuntimeHints.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public static StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    @Bean
    public FlywaySchemaManagementProvider flywayDefaultDdlModeProvider(ObjectProvider<Flyway> flyways) {
        return new FlywaySchemaManagementProvider((Iterable<Flyway>)flyways);
    }

    static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        StringOrNumberToMigrationVersionConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString((Object)source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    static class Extension<E extends ConfigurationExtension> {
        private SingletonSupplier<E> extension = SingletonSupplier.of(() -> {
            ConfigurationExtension extension = (ConfigurationExtension)configuration.getPluginRegister().getPlugin(type);
            Assert.state((extension != null ? 1 : 0) != 0, () -> "Flyway %s extension missing".formatted(name));
            return extension;
        });

        Extension(FluentConfiguration configuration, Class<E> type, String name) {
        }

        <T> Consumer<T> via(BiConsumer<E, T> action) {
            return value -> action.accept((ConfigurationExtension)this.extension.get(), value);
        }
    }

    @Order(value=-2147483648)
    static final class SqlServerFlywayConfigurationCustomizer
    implements FlywayConfigurationCustomizer {
        private final FlywayProperties properties;

        SqlServerFlywayConfigurationCustomizer(FlywayProperties properties) {
            this.properties = properties;
        }

        @Override
        public void customize(FluentConfiguration configuration) {
            Extension<SQLServerConfigurationExtension> extension = new Extension<SQLServerConfigurationExtension>(configuration, SQLServerConfigurationExtension.class, "SQL Server");
            FlywayProperties.Sqlserver properties = this.properties.getSqlserver();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(properties::getKerberosLoginFile).to(extension.via(this::setKerberosLoginFile));
        }

        private void setKerberosLoginFile(SQLServerConfigurationExtension configuration, String file) {
            configuration.getKerberos().getLogin().setFile(file);
        }
    }

    @Order(value=-2147483648)
    static final class PostgresqlFlywayConfigurationCustomizer
    implements FlywayConfigurationCustomizer {
        private final FlywayProperties properties;

        PostgresqlFlywayConfigurationCustomizer(FlywayProperties properties) {
            this.properties = properties;
        }

        @Override
        public void customize(FluentConfiguration configuration) {
            Extension<PostgreSQLConfigurationExtension> extension = new Extension<PostgreSQLConfigurationExtension>(configuration, PostgreSQLConfigurationExtension.class, "PostgreSQL");
            FlywayProperties.Postgresql properties = this.properties.getPostgresql();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(properties::getTransactionalLock).to(extension.via((ext, transactionalLock) -> ext.setTransactionalLock(transactionalLock.booleanValue())));
        }
    }

    @Order(value=-2147483648)
    static final class OracleFlywayConfigurationCustomizer
    implements FlywayConfigurationCustomizer {
        private final FlywayProperties properties;

        OracleFlywayConfigurationCustomizer(FlywayProperties properties) {
            this.properties = properties;
        }

        @Override
        public void customize(FluentConfiguration configuration) {
            Extension<OracleConfigurationExtension> extension = new Extension<OracleConfigurationExtension>(configuration, OracleConfigurationExtension.class, "Oracle");
            FlywayProperties.Oracle properties = this.properties.getOracle();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(properties::getSqlplus).to(extension.via((ext, sqlplus) -> ext.setSqlplus(sqlplus)));
            map.from(properties::getSqlplusWarn).to(extension.via((ext, sqlplusWarn) -> ext.setSqlplusWarn(sqlplusWarn)));
            map.from(properties::getWalletLocation).to(extension.via((ext, walletLocation) -> ext.setWalletLocation(walletLocation)));
            map.from(properties::getKerberosCacheFile).to(extension.via((ext, kerberosCacheFile) -> ext.setKerberosCacheFile(kerberosCacheFile)));
        }
    }

    static final class PropertiesFlywayConnectionDetails
    implements FlywayConnectionDetails {
        private final FlywayProperties properties;

        PropertiesFlywayConnectionDetails(FlywayProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUsername() {
            return this.properties.getUser();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.properties.getUrl();
        }

        @Override
        public String getDriverClassName() {
            return this.properties.getDriverClassName();
        }
    }

    static class FlywayAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        FlywayAutoConfigurationRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("db/migration/*");
        }
    }

    static final class FlywayDataSourceCondition
    extends AnyNestedCondition {
        FlywayDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.flyway.url"})
        private static final class FlywayUrlCondition {
            private FlywayUrlCondition() {
            }
        }

        @ConditionalOnBean(value={JdbcConnectionDetails.class})
        private static final class JdbcConnectionDetailsCondition {
            private JdbcConnectionDetailsCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        List<String> resolveLocations(List<String> locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private List<String> replaceVendorLocations(List<String> locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return locations.stream().map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).toList();
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getURL);
                return DatabaseDriver.fromJdbcUrl((String)url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(Collection<String> locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JdbcUtils.class})
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class FlywayConfiguration {
        private final FlywayProperties properties;

        FlywayConfiguration(FlywayProperties properties) {
            this.properties = properties;
        }

        @Bean
        ResourceProviderCustomizer resourceProviderCustomizer() {
            return new ResourceProviderCustomizer();
        }

        @Bean
        @ConditionalOnMissingBean(value={FlywayConnectionDetails.class})
        PropertiesFlywayConnectionDetails flywayConnectionDetails() {
            return new PropertiesFlywayConnectionDetails(this.properties);
        }

        @Bean
        @ConditionalOnClass(name={"org.flywaydb.database.sqlserver.SQLServerConfigurationExtension"})
        SqlServerFlywayConfigurationCustomizer sqlServerFlywayConfigurationCustomizer() {
            return new SqlServerFlywayConfigurationCustomizer(this.properties);
        }

        @Bean
        @ConditionalOnClass(name={"org.flywaydb.database.oracle.OracleConfigurationExtension"})
        OracleFlywayConfigurationCustomizer oracleFlywayConfigurationCustomizer() {
            return new OracleFlywayConfigurationCustomizer(this.properties);
        }

        @Bean
        @ConditionalOnClass(name={"org.flywaydb.database.postgresql.PostgreSQLConfigurationExtension"})
        PostgresqlFlywayConfigurationCustomizer postgresqlFlywayConfigurationCustomizer() {
            return new PostgresqlFlywayConfigurationCustomizer(this.properties);
        }

        @Bean
        Flyway flyway(FlywayConnectionDetails connectionDetails, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks, ResourceProviderCustomizer resourceProviderCustomizer) {
            FluentConfiguration configuration = new FluentConfiguration(resourceLoader.getClassLoader());
            this.configureDataSource(configuration, (DataSource)flywayDataSource.getIfAvailable(), (DataSource)dataSource.getIfUnique(), connectionDetails);
            this.configureProperties(configuration, this.properties);
            this.configureCallbacks(configuration, callbacks.orderedStream().toList());
            this.configureJavaMigrations(configuration, javaMigrations.orderedStream().toList());
            fluentConfigurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
            resourceProviderCustomizer.customize(configuration);
            return configuration.load();
        }

        private void configureDataSource(FluentConfiguration configuration, DataSource flywayDataSource, DataSource dataSource, FlywayConnectionDetails connectionDetails) {
            DataSource migrationDataSource = this.getMigrationDataSource(flywayDataSource, dataSource, connectionDetails);
            configuration.dataSource(migrationDataSource);
        }

        private DataSource getMigrationDataSource(DataSource flywayDataSource, DataSource dataSource, FlywayConnectionDetails connectionDetails) {
            if (flywayDataSource != null) {
                return flywayDataSource;
            }
            String url = connectionDetails.getJdbcUrl();
            if (url != null) {
                DataSourceBuilder builder = DataSourceBuilder.create().type(SimpleDriverDataSource.class);
                builder.url(url);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            String user = connectionDetails.getUsername();
            if (user != null && dataSource != null) {
                DataSourceBuilder builder = DataSourceBuilder.derivedFrom((DataSource)dataSource).type(SimpleDriverDataSource.class);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            Assert.state((dataSource != null ? 1 : 0) != 0, (String)"Flyway migration DataSource missing");
            return dataSource;
        }

        private void applyConnectionDetails(FlywayConnectionDetails connectionDetails, DataSourceBuilder<?> builder) {
            builder.username(connectionDetails.getUsername());
            builder.password(connectionDetails.getPassword());
            String driverClassName = connectionDetails.getDriverClassName();
            if (StringUtils.hasText((String)driverClassName)) {
                builder.driverClassName(driverClassName);
            }
        }

        private void configureProperties(FluentConfiguration configuration, FlywayProperties properties) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            String[] locations = new LocationResolver(configuration.getDataSource()).resolveLocations(properties.getLocations()).toArray(new String[0]);
            configuration.locations(locations);
            map.from((Object)properties.isFailOnMissingLocations()).to(failOnMissingLocations -> configuration.failOnMissingLocations(failOnMissingLocations.booleanValue()));
            map.from((Object)properties.getEncoding()).to(encoding -> configuration.encoding(encoding));
            map.from((Object)properties.getConnectRetries()).to(connectRetries -> configuration.connectRetries(connectRetries.intValue()));
            map.from((Object)properties.getConnectRetriesInterval()).as(Duration::getSeconds).as(Long::intValue).to(connectRetriesInterval -> configuration.connectRetriesInterval(connectRetriesInterval.intValue()));
            map.from((Object)properties.getLockRetryCount()).to(lockRetryCount -> configuration.lockRetryCount(lockRetryCount.intValue()));
            map.from((Object)properties.getDefaultSchema()).to(schema -> configuration.defaultSchema(schema));
            map.from(properties.getSchemas()).as(StringUtils::toStringArray).to(schemas -> configuration.schemas(schemas));
            map.from((Object)properties.isCreateSchemas()).to(createSchemas -> configuration.createSchemas(createSchemas.booleanValue()));
            map.from((Object)properties.getTable()).to(table -> configuration.table(table));
            map.from((Object)properties.getTablespace()).to(tablespace -> configuration.tablespace(tablespace));
            map.from((Object)properties.getBaselineDescription()).to(baselineDescription -> configuration.baselineDescription(baselineDescription));
            map.from((Object)properties.getBaselineVersion()).to(baselineVersion -> configuration.baselineVersion(baselineVersion));
            map.from((Object)properties.getInstalledBy()).to(installedBy -> configuration.installedBy(installedBy));
            map.from(properties.getPlaceholders()).to(placeholders -> configuration.placeholders(placeholders));
            map.from((Object)properties.getPlaceholderPrefix()).to(placeholderPrefix -> configuration.placeholderPrefix(placeholderPrefix));
            map.from((Object)properties.getPlaceholderSuffix()).to(placeholderSuffix -> configuration.placeholderSuffix(placeholderSuffix));
            map.from((Object)properties.getPlaceholderSeparator()).to(placeHolderSeparator -> configuration.placeholderSeparator(placeHolderSeparator));
            map.from((Object)properties.isPlaceholderReplacement()).to(placeholderReplacement -> configuration.placeholderReplacement(placeholderReplacement.booleanValue()));
            map.from((Object)properties.getSqlMigrationPrefix()).to(sqlMigrationPrefix -> configuration.sqlMigrationPrefix(sqlMigrationPrefix));
            map.from(properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(sqlMigrationSuffixes -> configuration.sqlMigrationSuffixes(sqlMigrationSuffixes));
            map.from((Object)properties.getSqlMigrationSeparator()).to(sqlMigrationSeparator -> configuration.sqlMigrationSeparator(sqlMigrationSeparator));
            map.from((Object)properties.getRepeatableSqlMigrationPrefix()).to(repeatableSqlMigrationPrefix -> configuration.repeatableSqlMigrationPrefix(repeatableSqlMigrationPrefix));
            map.from((Object)properties.getTarget()).to(target -> configuration.target(target));
            map.from((Object)properties.isBaselineOnMigrate()).to(baselineOnMigrate -> configuration.baselineOnMigrate(baselineOnMigrate.booleanValue()));
            map.from((Object)properties.isCleanDisabled()).to(cleanDisabled -> configuration.cleanDisabled(cleanDisabled.booleanValue()));
            map.from((Object)properties.isCleanOnValidationError()).to(cleanOnValidationError -> configuration.cleanOnValidationError(cleanOnValidationError.booleanValue()));
            map.from((Object)properties.isGroup()).to(group -> configuration.group(group.booleanValue()));
            map.from((Object)properties.isMixed()).to(mixed -> configuration.mixed(mixed.booleanValue()));
            map.from((Object)properties.isOutOfOrder()).to(outOfOrder -> configuration.outOfOrder(outOfOrder.booleanValue()));
            map.from((Object)properties.isSkipDefaultCallbacks()).to(skipDefaultCallbacks -> configuration.skipDefaultCallbacks(skipDefaultCallbacks.booleanValue()));
            map.from((Object)properties.isSkipDefaultResolvers()).to(skipDefaultResolvers -> configuration.skipDefaultResolvers(skipDefaultResolvers.booleanValue()));
            map.from((Object)properties.isValidateMigrationNaming()).to(validateMigrationNaming -> configuration.validateMigrationNaming(validateMigrationNaming.booleanValue()));
            map.from((Object)properties.isValidateOnMigrate()).to(validateOnMigrate -> configuration.validateOnMigrate(validateOnMigrate.booleanValue()));
            map.from(properties.getInitSqls()).whenNot(CollectionUtils::isEmpty).as(initSqls -> StringUtils.collectionToDelimitedString((Collection)initSqls, (String)"\n")).to(initSql -> configuration.initSql(initSql));
            map.from((Object)properties.getScriptPlaceholderPrefix()).to(prefix -> configuration.scriptPlaceholderPrefix(prefix));
            map.from((Object)properties.getScriptPlaceholderSuffix()).to(suffix -> configuration.scriptPlaceholderSuffix(suffix));
            this.configureExecuteInTransaction(configuration, properties, map);
            map.from(properties::getLoggers).to(loggers -> configuration.loggers(loggers));
            map.from(properties::getCommunityDbSupportEnabled).to(communityDbSupportEnabled -> configuration.communityDBSupportEnabled(communityDbSupportEnabled.booleanValue()));
            map.from((Object)properties.getBatch()).to(batch -> configuration.batch(batch.booleanValue()));
            map.from((Object)properties.getDryRunOutput()).to(dryRunOutput -> configuration.dryRunOutput(dryRunOutput));
            map.from((Object)properties.getErrorOverrides()).to(errorOverrides -> configuration.errorOverrides(errorOverrides));
            map.from((Object)properties.getStream()).to(stream -> configuration.stream(stream.booleanValue()));
            map.from(properties.getJdbcProperties()).whenNot(Map::isEmpty).to(jdbcProperties -> configuration.jdbcProperties(jdbcProperties));
            map.from((Object)properties.getKerberosConfigFile()).to(configFile -> configuration.kerberosConfigFile(configFile));
            map.from((Object)properties.getOutputQueryResults()).to(outputQueryResults -> configuration.outputQueryResults(outputQueryResults.booleanValue()));
            map.from((Object)properties.getSkipExecutingMigrations()).to(skipExecutingMigrations -> configuration.skipExecutingMigrations(skipExecutingMigrations.booleanValue()));
            map.from(properties.getIgnoreMigrationPatterns()).to(ignoreMigrationPatterns -> configuration.ignoreMigrationPatterns(ignoreMigrationPatterns.toArray(new String[0])));
            map.from((Object)properties.getDetectEncoding()).to(detectEncoding -> configuration.detectEncoding(detectEncoding.booleanValue()));
        }

        private void configureExecuteInTransaction(FluentConfiguration configuration, FlywayProperties properties, PropertyMapper map) {
            try {
                map.from((Object)properties.isExecuteInTransaction()).to(arg_0 -> ((FluentConfiguration)configuration).executeInTransaction(arg_0));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        private void configureCallbacks(FluentConfiguration configuration, List<Callback> callbacks) {
            if (!callbacks.isEmpty()) {
                configuration.callbacks(callbacks.toArray(new Callback[0]));
            }
        }

        private void configureJavaMigrations(FluentConfiguration flyway, List<JavaMigration> migrations) {
            if (!migrations.isEmpty()) {
                flyway.javaMigrations(migrations.toArray(new JavaMigration[0]));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway, ObjectProvider<FlywayMigrationStrategy> migrationStrategy) {
            return new FlywayMigrationInitializer(flyway, (FlywayMigrationStrategy)migrationStrategy.getIfAvailable());
        }
    }
}

