/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.socket;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NamedPipeSocket
extends Socket {
    private static final int WAIT_INTERVAL = 100;
    private static final long TIMEOUT = TimeUnit.MILLISECONDS.toNanos(1000L);
    private final RandomAccessFile file;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    NamedPipeSocket(String path) throws IOException {
        this.file = NamedPipeSocket.open(path);
        this.inputStream = new NamedPipeInputStream();
        this.outputStream = new NamedPipeOutputStream();
    }

    private static RandomAccessFile open(String path) throws IOException {
        Consumer<String> awaiter = Platform.isWindows() ? new WindowsAwaiter() : new SleepAwaiter();
        long startTime = System.nanoTime();
        while (true) {
            try {
                return new RandomAccessFile(path, "rw");
            }
            catch (FileNotFoundException ex) {
                if (System.nanoTime() - startTime > TIMEOUT) {
                    throw ex;
                }
                awaiter.accept(path);
                continue;
            }
            break;
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    protected final RandomAccessFile getFile() {
        return this.file;
    }

    public static NamedPipeSocket get(String path) throws IOException {
        return new NamedPipeSocket(path);
    }

    private static class WindowsAwaiter
    implements Consumer<String> {
        private WindowsAwaiter() {
        }

        @Override
        public void accept(String path) {
            Kernel32.INSTANCE.WaitNamedPipe(path, 100);
        }
    }

    private static class SleepAwaiter
    implements Consumer<String> {
        private SleepAwaiter() {
        }

        @Override
        public void accept(String path) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class NamedPipeOutputStream
    extends OutputStream {
        private NamedPipeOutputStream() {
        }

        @Override
        public void write(int value) throws IOException {
            NamedPipeSocket.this.file.write(value);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            NamedPipeSocket.this.file.write(bytes, off, len);
        }
    }

    private class NamedPipeInputStream
    extends InputStream {
        private NamedPipeInputStream() {
        }

        @Override
        public int read() throws IOException {
            return NamedPipeSocket.this.getFile().read();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            return NamedPipeSocket.this.getFile().read(bytes, off, len);
        }
    }
}

