/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildOwner;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.EphemeralBuilder;
import org.springframework.boot.buildpack.platform.build.Lifecycle;
import org.springframework.boot.buildpack.platform.build.StackId;
import org.springframework.boot.buildpack.platform.docker.DockerApi;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressPullListener;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Builder {
    private final BuildLog log;
    private final DockerApi docker;

    public Builder() {
        this(BuildLog.toSystemOut());
    }

    public Builder(BuildLog log) {
        this(log, new DockerApi());
    }

    Builder(BuildLog log, DockerApi docker) {
        Assert.notNull((Object)log, (String)"Log must not be null");
        this.log = log;
        this.docker = docker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(BuildRequest request) throws DockerEngineException, IOException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.log.start(request);
        Image builderImage = this.pullBuilder(request);
        BuilderMetadata builderMetadata = BuilderMetadata.fromImage(builderImage);
        BuildOwner buildOwner = BuildOwner.fromEnv(builderImage.getConfig().getEnv());
        StackId stackId = StackId.fromImage(builderImage);
        ImageReference runImageReference = this.getRunImageReference(builderMetadata.getStack());
        Image runImage = this.pullRunImage(request, runImageReference);
        this.assertHasExpectedStackId(runImage, stackId);
        EphemeralBuilder builder = new EphemeralBuilder(buildOwner, builderImage, builderMetadata, request.getCreator(), request.getEnv());
        this.docker.image().load(builder.getArchive(), UpdateListener.none());
        try {
            this.executeLifecycle(request, runImageReference, builder);
        }
        finally {
            this.docker.image().remove(builder.getName(), true);
        }
    }

    private Image pullBuilder(BuildRequest request) throws IOException {
        ImageReference builderImageReference = request.getBuilder();
        Consumer<TotalProgressEvent> progressConsumer = this.log.pullingBuilder(request, builderImageReference);
        TotalProgressPullListener listener = new TotalProgressPullListener(progressConsumer);
        Image builderImage = this.docker.image().pull(builderImageReference, listener);
        this.log.pulledBuilder(request, builderImage);
        return builderImage;
    }

    private ImageReference getRunImageReference(BuilderMetadata.Stack stack) {
        String name = stack.getRunImage().getImage();
        Assert.state((boolean)StringUtils.hasText((String)name), (String)"Run image must be specified");
        return ImageReference.of(name).inTaggedForm();
    }

    private Image pullRunImage(BuildRequest request, ImageReference name) throws IOException {
        Consumer<TotalProgressEvent> progressConsumer = this.log.pullingRunImage(request, name);
        TotalProgressPullListener listener = new TotalProgressPullListener(progressConsumer);
        Image image = this.docker.image().pull(name, listener);
        this.log.pulledRunImage(request, image);
        return image;
    }

    private void assertHasExpectedStackId(Image image, StackId stackId) {
        StackId pulledStackId = StackId.fromImage(image);
        Assert.state((boolean)pulledStackId.equals(stackId), (String)("Run image stack '" + pulledStackId + "' does not match builder stack '" + stackId + "'"));
    }

    private void executeLifecycle(BuildRequest request, ImageReference runImageReference, EphemeralBuilder builder) throws IOException {
        try (Lifecycle lifecycle = new Lifecycle(this.log, this.docker, request, runImageReference, builder);){
            lifecycle.execute();
        }
    }
}

