/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.ApiVersion;
import org.springframework.boot.buildpack.platform.build.ApiVersions;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuilderException;
import org.springframework.boot.buildpack.platform.build.EphemeralBuilder;
import org.springframework.boot.buildpack.platform.build.LifecycleVersion;
import org.springframework.boot.buildpack.platform.build.Phase;
import org.springframework.boot.buildpack.platform.docker.DockerApi;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.type.ContainerConfig;
import org.springframework.boot.buildpack.platform.docker.type.ContainerContent;
import org.springframework.boot.buildpack.platform.docker.type.ContainerReference;
import org.springframework.boot.buildpack.platform.docker.type.ContainerStatus;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

class Lifecycle
implements Closeable {
    private static final LifecycleVersion LOGGING_MINIMUM_VERSION = LifecycleVersion.parse("0.0.5");
    private final BuildLog log;
    private final DockerApi docker;
    private final BuildRequest request;
    private final ImageReference runImageReference;
    private final EphemeralBuilder builder;
    private final LifecycleVersion lifecycleVersion;
    private final ApiVersion platformVersion;
    private final VolumeName layersVolume;
    private final VolumeName applicationVolume;
    private final VolumeName buildCacheVolume;
    private final VolumeName launchCacheVolume;
    private boolean executed;
    private boolean applicationVolumePopulated;

    Lifecycle(BuildLog log, DockerApi docker, BuildRequest request, ImageReference runImageReference, EphemeralBuilder builder) {
        this.log = log;
        this.docker = docker;
        this.request = request;
        this.runImageReference = runImageReference;
        this.builder = builder;
        this.lifecycleVersion = LifecycleVersion.parse(builder.getBuilderMetadata().getLifecycle().getVersion());
        this.platformVersion = ApiVersion.parse(builder.getBuilderMetadata().getLifecycle().getApi().getPlatform());
        this.layersVolume = this.createRandomVolumeName("pack-layers-");
        this.applicationVolume = this.createRandomVolumeName("pack-app-");
        this.buildCacheVolume = this.createCacheVolumeName(request, ".build");
        this.launchCacheVolume = this.createCacheVolumeName(request, ".launch");
        this.checkPlatformVersion(this.platformVersion);
    }

    protected VolumeName createRandomVolumeName(String prefix) {
        return VolumeName.random(prefix);
    }

    private VolumeName createCacheVolumeName(BuildRequest request, String suffix) {
        return VolumeName.basedOn(request.getName(), ImageReference::toLegacyString, "pack-cache-", suffix, 6);
    }

    private void checkPlatformVersion(ApiVersion platformVersion) {
        ApiVersions.SUPPORTED_PLATFORMS.assertSupports(platformVersion);
    }

    void execute() throws IOException {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"Lifecycle has already been executed");
        this.executed = true;
        this.log.executingLifecycle(this.request, this.lifecycleVersion, this.buildCacheVolume);
        if (this.request.isCleanCache()) {
            this.deleteVolume(this.buildCacheVolume);
        }
        this.run(this.createPhase());
        this.log.executedLifecycle(this.request);
    }

    private Phase createPhase() {
        Phase phase = new Phase("creator", this.isVerboseLogging());
        phase.withDaemonAccess();
        phase.withLogLevelArg();
        phase.withArgs("-app", "/workspace");
        phase.withArgs("-platform", "/platform");
        phase.withArgs("-run-image", this.runImageReference);
        phase.withArgs("-layers", "/layers");
        phase.withArgs("-cache-dir", "/cache");
        phase.withArgs("-launch-cache", "/launch-cache");
        phase.withArgs("-daemon");
        if (this.request.isCleanCache()) {
            phase.withArgs("-skip-restore");
        }
        phase.withArgs(this.request.getName());
        phase.withBinds(this.layersVolume, "/layers");
        phase.withBinds(this.applicationVolume, "/workspace");
        phase.withBinds(this.buildCacheVolume, "/cache");
        phase.withBinds(this.launchCacheVolume, "/launch-cache");
        return phase;
    }

    private boolean isVerboseLogging() {
        return this.request.isVerboseLogging() && this.lifecycleVersion.isEqualOrGreaterThan(LOGGING_MINIMUM_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Phase phase) throws IOException {
        Consumer<LogUpdateEvent> logConsumer = this.log.runningPhase(this.request, phase.getName());
        ContainerConfig containerConfig = ContainerConfig.of(this.builder.getName(), phase::apply);
        ContainerReference reference = this.createContainer(containerConfig);
        try {
            this.docker.container().start(reference);
            this.docker.container().logs(reference, logConsumer::accept);
            ContainerStatus status = this.docker.container().wait(reference);
            if (status.getStatusCode() != 0) {
                throw new BuilderException(phase.getName(), status.getStatusCode());
            }
        }
        finally {
            this.docker.container().remove(reference, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerReference createContainer(ContainerConfig config) throws IOException {
        if (this.applicationVolumePopulated) {
            return this.docker.container().create(config, new ContainerContent[0]);
        }
        try {
            TarArchive applicationContent = this.request.getApplicationContent(this.builder.getBuildOwner());
            ContainerReference containerReference = this.docker.container().create(config, ContainerContent.of(applicationContent, "/workspace"));
            return containerReference;
        }
        finally {
            this.applicationVolumePopulated = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.deleteVolume(this.layersVolume);
        this.deleteVolume(this.applicationVolume);
    }

    private void deleteVolume(VolumeName name) throws IOException {
        this.docker.volume().delete(name, true);
    }

    private static class Directory {
        static final String LAYERS = "/layers";
        static final String APPLICATION = "/workspace";
        static final String PLATFORM = "/platform";
        static final String CACHE = "/cache";
        static final String LAUNCH_CACHE = "/launch-cache";

        private Directory() {
        }
    }
}

