/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.json.MappedObject;

public class Image
extends MappedObject {
    private final List<String> digests = this.getDigests(this.getNode().at("/RepoDigests"));
    private final ImageConfig config = new ImageConfig(this.getNode().at("/Config"));
    private final List<LayerId> layers = this.extractLayers(this.valueAt("/RootFS/Layers", String[].class));
    private final String os = this.valueAt("/Os", String.class);

    Image(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private List<String> getDigests(JsonNode node) {
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList digests = new ArrayList();
        node.forEach(child -> digests.add(child.asText()));
        return Collections.unmodifiableList(digests);
    }

    private List<LayerId> extractLayers(String[] layers) {
        if (layers == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(layers).map(LayerId::of).toList();
    }

    public List<String> getDigests() {
        return this.digests;
    }

    public ImageConfig getConfig() {
        return this.config;
    }

    public List<LayerId> getLayers() {
        return this.layers;
    }

    public String getOs() {
        return this.os != null ? this.os : "linux";
    }

    public static Image of(InputStream content) throws IOException {
        return Image.of(content, Image::new);
    }
}

