/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import org.springframework.boot.buildpack.platform.socket.AbstractSocket;

public final class UnixDomainSocket
extends AbstractSocket {
    private final SocketAddress socketAddress;
    private final SocketChannel socketChannel;

    public static Socket get(String path) throws IOException {
        return new UnixDomainSocket(path);
    }

    private UnixDomainSocket(String path) throws IOException {
        this.socketAddress = UnixDomainSocketAddress.of(path);
        this.socketChannel = SocketChannel.open(this.socketAddress);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return Channels.newInputStream(this.socketChannel);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return Channels.newOutputStream(this.socketChannel);
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.socketChannel.close();
    }
}

