/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.HttpClientSettingsPropertyMapper;
import org.springframework.boot.http.client.autoconfigure.HttpClientsProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={SslAutoConfiguration.class})
@EnableConfigurationProperties(value={HttpClientsProperties.class})
public final class HttpClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    HttpClientSettings httpClientSettings(ObjectProvider<SslBundles> sslBundles, HttpClientsProperties properties) {
        HttpClientSettingsPropertyMapper propertyMapper = new HttpClientSettingsPropertyMapper((SslBundles)sslBundles.getIfAvailable(), null);
        return propertyMapper.map(properties);
    }
}

