/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson.autoconfigure;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.json.ConditionalOnJsonTesters;
import org.springframework.boot.test.autoconfigure.json.JsonMarshalTesterRuntimeHints;
import org.springframework.boot.test.autoconfigure.json.JsonTesterFactoryBean;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Scope;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@ConditionalOnJsonTesters
final class JacksonTesterTestAutoConfiguration {
    JacksonTesterTestAutoConfiguration() {
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnBean(value={JsonMapper.class})
    @ImportRuntimeHints(value={JacksonTesterRuntimeHints.class})
    FactoryBean<JacksonTester<?>> jacksonTesterFactoryBean(JsonMapper mapper) {
        return new JsonTesterFactoryBean(JacksonTester.class, (Object)mapper);
    }

    static class JacksonTesterRuntimeHints
    extends JsonMarshalTesterRuntimeHints {
        JacksonTesterRuntimeHints() {
            super(JacksonTester.class);
        }
    }
}

