/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LoaderClassesWriter;

public class JarWriter
implements LoaderClassesWriter,
AutoCloseable {
    private static final UnpackHandler NEVER_UNPACK = new NeverUnpackHandler();
    private static final String NESTED_LOADER_JAR = "META-INF/loader/spring-boot-loader.jar";
    private static final int BUFFER_SIZE = 32768;
    private final JarArchiveOutputStream jarOutput;
    private final Set<String> writtenEntries = new HashSet<String>();

    public JarWriter(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public JarWriter(File file, LaunchScript launchScript) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (launchScript != null) {
            fileOutputStream.write(launchScript.toByteArray());
            this.setExecutableFilePermission(file);
        }
        this.jarOutput = new JarArchiveOutputStream((OutputStream)fileOutputStream);
        this.jarOutput.setEncoding("UTF-8");
    }

    private void setExecutableFilePermission(File file) {
        try {
            Path path = file.toPath();
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeManifest(Manifest manifest) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry("META-INF/MANIFEST.MF");
        this.writeEntry(entry, manifest::write);
    }

    public void writeEntries(JarFile jarFile) throws IOException {
        this.writeEntries(jarFile, new IdentityEntryTransformer(), NEVER_UNPACK);
    }

    void writeEntries(JarFile jarFile, UnpackHandler unpackHandler) throws IOException {
        this.writeEntries(jarFile, new IdentityEntryTransformer(), unpackHandler);
    }

    void writeEntries(JarFile jarFile, EntryTransformer entryTransformer, UnpackHandler unpackHandler) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarArchiveEntry entry = new JarArchiveEntry(entries.nextElement());
            this.setUpStoredEntryIfNecessary(jarFile, entry);
            ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream((ZipEntry)entry));
            Throwable throwable = null;
            try {
                InputStreamEntryWriter entryWriter = new InputStreamEntryWriter(inputStream, true);
                JarArchiveEntry transformedEntry = entryTransformer.transform(entry);
                if (transformedEntry == null) continue;
                this.writeEntry(transformedEntry, entryWriter, unpackHandler);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }

    private void setUpStoredEntryIfNecessary(JarFile jarFile, JarArchiveEntry entry) throws IOException {
        try (ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream((ZipEntry)entry));){
            if (inputStream.hasZipHeader() && entry.getMethod() != 0) {
                new CrcAndSize(inputStream).setupStoredEntry(entry);
            }
        }
    }

    @Override
    public void writeEntry(String entryName, InputStream inputStream) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry(entryName);
        this.writeEntry(entry, new InputStreamEntryWriter(inputStream, true));
    }

    public void writeNestedLibrary(String destination, Library library) throws IOException {
        File file = library.getFile();
        JarArchiveEntry entry = new JarArchiveEntry(destination + library.getName());
        entry.setTime(this.getNestedLibraryTime(file));
        new CrcAndSize(file).setupStoredEntry(entry);
        this.writeEntry(entry, new InputStreamEntryWriter(new FileInputStream(file), true), new LibraryUnpackHandler(library));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNestedLibraryTime(File file) {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry entry;
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return file.lastModified();
            } while ((entry = entries.nextElement()).isDirectory());
            long l = entry.getTime();
            return l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.lastModified();
    }

    @Override
    public void writeLoaderClasses() throws IOException {
        this.writeLoaderClasses(NESTED_LOADER_JAR);
    }

    @Override
    public void writeLoaderClasses(String loaderJarResourceName) throws IOException {
        URL loaderJar = this.getClass().getClassLoader().getResource(loaderJarResourceName);
        try (JarInputStream inputStream = new JarInputStream(new BufferedInputStream(loaderJar.openStream()));){
            JarEntry entry;
            while ((entry = inputStream.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                this.writeEntry(new JarArchiveEntry(entry), new InputStreamEntryWriter(inputStream, false));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.jarOutput.close();
    }

    private void writeEntry(JarArchiveEntry entry, EntryWriter entryWriter) throws IOException {
        this.writeEntry(entry, entryWriter, NEVER_UNPACK);
    }

    private void writeEntry(JarArchiveEntry entry, EntryWriter entryWriter, UnpackHandler unpackHandler) throws IOException {
        String parent = entry.getName();
        if (parent.endsWith("/")) {
            parent = parent.substring(0, parent.length() - 1);
            entry.setUnixMode(16877);
        } else {
            entry.setUnixMode(33188);
        }
        if (parent.lastIndexOf(47) != -1 && !(parent = parent.substring(0, parent.lastIndexOf(47) + 1)).isEmpty()) {
            this.writeEntry(new JarArchiveEntry(parent), null, unpackHandler);
        }
        if (this.writtenEntries.add(entry.getName())) {
            entryWriter = this.addUnpackCommentIfNecessary(entry, entryWriter, unpackHandler);
            this.jarOutput.putArchiveEntry((ArchiveEntry)entry);
            if (entryWriter != null) {
                entryWriter.write((OutputStream)this.jarOutput);
            }
            this.jarOutput.closeArchiveEntry();
        }
    }

    private EntryWriter addUnpackCommentIfNecessary(JarArchiveEntry entry, EntryWriter entryWriter, UnpackHandler unpackHandler) throws IOException {
        if (entryWriter == null || !unpackHandler.requiresUnpack(entry.getName())) {
            return entryWriter;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        entryWriter.write(output);
        entry.setComment("UNPACK:" + unpackHandler.sha1Hash(entry.getName()));
        return new InputStreamEntryWriter(new ByteArrayInputStream(output.toByteArray()), true);
    }

    private static final class LibraryUnpackHandler
    implements UnpackHandler {
        private final Library library;

        private LibraryUnpackHandler(Library library) {
            this.library = library;
        }

        @Override
        public boolean requiresUnpack(String name) {
            return this.library.isUnpackRequired();
        }

        @Override
        public String sha1Hash(String name) throws IOException {
            return FileUtils.sha1Hash(this.library.getFile());
        }
    }

    private static final class NeverUnpackHandler
    implements UnpackHandler {
        private NeverUnpackHandler() {
        }

        @Override
        public boolean requiresUnpack(String name) {
            return false;
        }

        @Override
        public String sha1Hash(String name) {
            throw new UnsupportedOperationException();
        }
    }

    static interface UnpackHandler {
        public boolean requiresUnpack(String var1);

        public String sha1Hash(String var1) throws IOException;
    }

    private static final class IdentityEntryTransformer
    implements EntryTransformer {
        private IdentityEntryTransformer() {
        }

        @Override
        public JarArchiveEntry transform(JarArchiveEntry jarEntry) {
            return jarEntry;
        }
    }

    static interface EntryTransformer {
        public JarArchiveEntry transform(JarArchiveEntry var1);
    }

    private static class CrcAndSize {
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(File file) throws IOException {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.load(inputStream);
            }
        }

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        public void setupStoredEntry(JarArchiveEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }

    static class ZipHeaderPeekInputStream
    extends FilterInputStream {
        private static final byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};
        private final byte[] header = new byte[4];
        private final int headerLength;
        private int position;
        private ByteArrayInputStream headerStream;

        protected ZipHeaderPeekInputStream(InputStream in) throws IOException {
            super(in);
            this.headerLength = in.read(this.header);
            this.headerStream = new ByteArrayInputStream(this.header, 0, this.headerLength);
        }

        @Override
        public int read() throws IOException {
            int read;
            int n = read = this.headerStream != null ? this.headerStream.read() : -1;
            if (read != -1) {
                ++this.position;
                if (this.position >= this.headerLength) {
                    this.headerStream = null;
                }
                return read;
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            int n = read = this.headerStream != null ? this.headerStream.read(b, off, len) : -1;
            if (read > 0) {
                this.position += read;
            } else {
                read = 0;
            }
            if (read < len) {
                read += super.read(b, off + read, len - read);
                this.position += read;
            }
            if (this.position >= this.headerLength) {
                this.headerStream = null;
            }
            return read;
        }

        public boolean hasZipHeader() {
            return Arrays.equals(this.header, ZIP_HEADER);
        }
    }

    private static class InputStreamEntryWriter
    implements EntryWriter {
        private final InputStream inputStream;
        private final boolean close;

        InputStreamEntryWriter(InputStream inputStream, boolean close) {
            this.inputStream = inputStream;
            this.close = close;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            if (this.close) {
                this.inputStream.close();
            }
        }
    }

    private static interface EntryWriter {
        public void write(OutputStream var1) throws IOException;
    }
}

