/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.LaunchScript;

public class JarWriter
extends AbstractJarWriter
implements AutoCloseable {
    private final JarArchiveOutputStream jarOutputStream;
    private final FileTime lastModifiedTime;

    public JarWriter(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public JarWriter(File file, LaunchScript launchScript) throws FileNotFoundException, IOException {
        this(file, launchScript, null);
    }

    public JarWriter(File file, LaunchScript launchScript, FileTime lastModifiedTime) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (launchScript != null) {
            fileOutputStream.write(launchScript.toByteArray());
            this.setExecutableFilePermission(file);
        }
        this.jarOutputStream = new JarArchiveOutputStream((OutputStream)fileOutputStream);
        this.jarOutputStream.setEncoding("UTF-8");
        this.lastModifiedTime = lastModifiedTime;
    }

    private void setExecutableFilePermission(File file) {
        try {
            Path path = file.toPath();
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void writeToArchive(ZipEntry entry, EntryWriter entryWriter) throws IOException {
        JarArchiveEntry jarEntry = this.asJarArchiveEntry(entry);
        if (this.lastModifiedTime != null) {
            jarEntry.setLastModifiedTime(this.lastModifiedTime);
        }
        this.jarOutputStream.putArchiveEntry((ArchiveEntry)jarEntry);
        if (entryWriter != null) {
            entryWriter.write((OutputStream)this.jarOutputStream);
        }
        this.jarOutputStream.closeArchiveEntry();
    }

    private JarArchiveEntry asJarArchiveEntry(ZipEntry entry) throws ZipException {
        if (entry instanceof JarArchiveEntry) {
            return (JarArchiveEntry)entry;
        }
        return new JarArchiveEntry(entry);
    }

    @Override
    public void close() throws IOException {
        this.jarOutputStream.close();
    }
}

