/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;

@Mojo(name="build-info", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class BuildInfoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/build-info.properties")
    private File outputFile;
    @Parameter
    private Map<String, String> additionalProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new BuildPropertiesWriter(this.outputFile).writeBuildProperties(new BuildPropertiesWriter.ProjectDetails(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getName(), this.additionalProperties));
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }
}

