/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.ArtifactsLibraries;
import org.springframework.boot.maven.Exclude;
import org.springframework.boot.maven.ExcludeFilter;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractDependencyFilterMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="spring-boot.repackage.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean attach = true;
    @Parameter
    private String mainClass;
    @Parameter
    private LayoutType layout;
    @Parameter
    private LayoutFactory layoutFactory;
    @Parameter
    private List<Dependency> requiresUnpack;
    @Parameter(defaultValue="false")
    private boolean executable;
    @Parameter
    private File embeddedLaunchScript;
    @Parameter
    private Properties embeddedLaunchScriptProperties;
    @Parameter(defaultValue="true")
    private boolean excludeDevtools = true;
    @Parameter(defaultValue="false")
    public boolean includeSystemScope;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping repackaging as per configuration.");
            return;
        }
        this.repackage();
    }

    private void repackage() throws MojoExecutionException {
        File source = this.project.getArtifact().getFile();
        File target = this.getTargetFile();
        Repackager repackager = this.getRepackager(source);
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), this.getFilters(this.getAdditionalFilters()));
        ArtifactsLibraries libraries = new ArtifactsLibraries(artifacts, this.requiresUnpack, this.getLog());
        try {
            LaunchScript launchScript = this.getLaunchScript();
            repackager.repackage(target, (Libraries)libraries, launchScript);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        this.updateArtifact(source, target, repackager.getBackupFile());
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier != null ? this.classifier.trim() : "";
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private Repackager getRepackager(File source) {
        Repackager repackager = new Repackager(source, this.layoutFactory);
        repackager.addMainClassTimeoutWarningListener((Repackager.MainClassTimeoutWarningListener)new LoggingMainClassTimeoutWarningListener());
        repackager.setMainClass(this.mainClass);
        if (this.layout != null) {
            this.getLog().info((CharSequence)("Layout: " + (Object)((Object)this.layout)));
            repackager.setLayout(this.layout.layout());
        }
        return repackager;
    }

    private ArtifactsFilter[] getAdditionalFilters() {
        ArrayList<ExcludeFilter> filters = new ArrayList<ExcludeFilter>();
        if (this.excludeDevtools) {
            Exclude exclude = new Exclude();
            exclude.setGroupId("org.springframework.boot");
            exclude.setArtifactId("spring-boot-devtools");
            ExcludeFilter filter = new ExcludeFilter(exclude);
            filters.add(filter);
        }
        if (!this.includeSystemScope) {
            filters.add((ExcludeFilter)new ScopeFilter(null, "system"));
        }
        return filters.toArray(new ArtifactsFilter[0]);
    }

    private LaunchScript getLaunchScript() throws IOException {
        if (this.executable || this.embeddedLaunchScript != null) {
            return new DefaultLaunchScript(this.embeddedLaunchScript, (Map)this.buildLaunchScriptProperties());
        }
        return null;
    }

    private Properties buildLaunchScriptProperties() {
        Properties properties = new Properties();
        if (this.embeddedLaunchScriptProperties != null) {
            properties.putAll((Map<?, ?>)this.embeddedLaunchScriptProperties);
        }
        this.putIfMissing(properties, "initInfoProvides", this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoShortDescription", this.project.getName(), this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoDescription", this.removeLineBreaks(this.project.getDescription()), this.project.getName(), this.project.getArtifactId());
        return properties;
    }

    private String removeLineBreaks(String description) {
        return description != null ? description.replaceAll("\\s+", " ") : null;
    }

    private void putIfMissing(Properties properties, String key, String ... valueCandidates) {
        if (!properties.containsKey(key)) {
            for (String candidate : valueCandidates) {
                if (candidate == null || candidate.isEmpty()) continue;
                properties.put(key, candidate);
                return;
            }
        }
    }

    private void updateArtifact(File source, File repackaged, File original) {
        if (this.attach) {
            this.attachArtifact(source, repackaged);
        } else if (source.equals(repackaged)) {
            this.project.getArtifact().setFile(original);
            this.getLog().info((CharSequence)("Updating main artifact " + source + " to " + original));
        }
    }

    private void attachArtifact(File source, File repackaged) {
        if (this.classifier != null) {
            this.getLog().info((CharSequence)("Attaching archive: " + repackaged + ", with classifier: " + this.classifier));
            this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), this.classifier, repackaged);
        } else if (!source.equals(repackaged)) {
            this.project.getArtifact().setFile(repackaged);
            this.getLog().info((CharSequence)("Replacing main artifact " + source + " to " + repackaged));
        }
    }

    public static enum LayoutType {
        JAR((Layout)new Layouts.Jar()),
        WAR((Layout)new Layouts.War()),
        ZIP((Layout)new Layouts.Expanded()),
        DIR((Layout)new Layouts.Expanded()),
        NONE((Layout)new Layouts.None());

        private final Layout layout;

        private LayoutType(Layout layout) {
            this.layout = layout;
        }

        public Layout layout() {
            return this.layout;
        }
    }

    private class LoggingMainClassTimeoutWarningListener
    implements Repackager.MainClassTimeoutWarningListener {
        private LoggingMainClassTimeoutWarningListener() {
        }

        public void handleTimeoutWarning(long duration, String mainMethod) {
            RepackageMojo.this.getLog().warn((CharSequence)"Searching for the main-class is taking some time, consider using the mainClass configuration parameter");
        }
    }
}

