/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.maven.SpringApplicationAdminClient;

@Mojo(name="stop", requiresProject=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="org.springframework.boot:type=Admin,name=SpringApplication")
    private String jmxName;
    @Parameter(defaultValue="9001")
    private int jmxPort;
    @Parameter(property="spring-boot.stop.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping stop as per configuration.");
            return;
        }
        this.getLog().info((CharSequence)"Stopping application...");
        try (JMXConnector connector = SpringApplicationAdminClient.connect(this.jmxPort);){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            this.stop(connection);
        }
        catch (IOException ex) {
            this.getLog().debug((CharSequence)("Service is not reachable anymore (" + ex.getMessage() + ")"));
        }
    }

    private void stop(MBeanServerConnection connection) throws IOException, MojoExecutionException {
        try {
            new SpringApplicationAdminClient(connection, this.jmxName).stop();
        }
        catch (InstanceNotFoundException ex) {
            throw new MojoExecutionException("Spring application lifecycle JMX bean not found. Could not stop application gracefully", (Exception)ex);
        }
    }
}

