/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import java.lang.reflect.Constructor;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ReflectionUtils;

public final class JsonTesterFactoryBean<T, M>
implements FactoryBean<T> {
    private final Class<?> objectType;
    private final @Nullable M marshaller;

    public JsonTesterFactoryBean(Class<?> objectType, @Nullable M marshaller) {
        this.objectType = objectType;
        this.marshaller = marshaller;
    }

    public boolean isSingleton() {
        return false;
    }

    public T getObject() throws Exception {
        Constructor<?>[] constructors;
        if (this.marshaller == null) {
            Constructor<?> constructor = this.objectType.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[0]);
        }
        for (Constructor<?> constructor : constructors = this.objectType.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isInstance(this.marshaller)) continue;
            ReflectionUtils.makeAccessible(constructor);
            return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.marshaller});
        }
        throw new IllegalStateException(String.valueOf(this.objectType) + " does not have a usable constructor");
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }
}

