/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.test.context.SpringBootConfigurationFinder;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class SpringBootTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    private static final String ACTIVATE_SERVLET_LISTENER = "org.springframework.test.context.web.ServletTestExecutionListener.activateListener";
    private static final Log logger = LogFactory.getLog(SpringBootTestContextBootstrapper.class);

    public TestContext buildTestContext() {
        TestContext context = super.buildTestContext();
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment(context.getTestClass());
        if (webEnvironment == SpringBootTest.WebEnvironment.MOCK && this.hasWebEnvironmentClasses()) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)true);
        } else if (webEnvironment != null && webEnvironment.isEmbedded()) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)false);
        }
        return context;
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Object[] classes = this.getClasses(testClass);
        if (!ObjectUtils.isEmpty((Object[])classes)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                this.addConfigAttributesClasses(configAttributes, (Class<?>[])classes);
            }
        }
        return super.resolveContextLoader(testClass, configAttributesList);
    }

    private void addConfigAttributesClasses(ContextConfigurationAttributes configAttributes, Class<?>[] classes) {
        ArrayList<Class> combined = new ArrayList<Class>();
        combined.addAll(Arrays.asList(classes));
        if (configAttributes.getClasses() != null) {
            combined.addAll(Arrays.asList(configAttributes.getClasses()));
        }
        configAttributes.setClasses(combined.toArray(new Class[combined.size()]));
    }

    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        return SpringBootContextLoader.class;
    }

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        List<String> propertySourceProperties;
        Class<?>[] classes = this.getOrFindConfigurationClasses(mergedConfig);
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment((mergedConfig = this.createModifiedConfig(mergedConfig, classes, (propertySourceProperties = this.getAndProcessPropertySourceProperties(mergedConfig)).toArray(new String[propertySourceProperties.size()]))).getTestClass());
        if (webEnvironment != null && (webEnvironment.isEmbedded() || webEnvironment == SpringBootTest.WebEnvironment.MOCK && this.hasWebEnvironmentClasses())) {
            WebAppConfiguration webAppConfiguration = (WebAppConfiguration)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)mergedConfig.getTestClass(), WebAppConfiguration.class);
            String resourceBasePath = webAppConfiguration == null ? "src/main/webapp" : webAppConfiguration.value();
            mergedConfig = new WebMergedContextConfiguration(mergedConfig, resourceBasePath);
        }
        return mergedConfig;
    }

    private boolean hasWebEnvironmentClasses() {
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return false;
        }
        return true;
    }

    protected Class<?>[] getOrFindConfigurationClasses(MergedContextConfiguration mergedConfig) {
        Class[] classes = mergedConfig.getClasses();
        if (this.containsNonTestComponent(classes) || mergedConfig.hasLocations() || !mergedConfig.getContextInitializerClasses().isEmpty()) {
            return classes;
        }
        Class<?> found = new SpringBootConfigurationFinder().findFromClass(mergedConfig.getTestClass());
        Assert.state((found != null ? 1 : 0) != 0, (String)"Unable to find a @SpringBootConfiguration, you need to use @ContextConfiguration or @SpringBootTest(classes=...) with your test");
        logger.info((Object)("Found @SpringBootConfiguration " + found.getName() + " for test " + mergedConfig.getTestClass()));
        return this.merge(found, classes);
    }

    private boolean containsNonTestComponent(Class<?>[] classes) {
        for (Class<?> candidate : classes) {
            if (AnnotatedElementUtils.isAnnotated(candidate, TestConfiguration.class)) continue;
            return true;
        }
        return false;
    }

    private Class<?>[] merge(Class<?> head, Class<?>[] existing) {
        Class[] result = new Class[existing.length + 1];
        result[0] = head;
        System.arraycopy(existing, 0, result, 1, existing.length);
        return result;
    }

    private List<String> getAndProcessPropertySourceProperties(MergedContextConfiguration mergedConfig) {
        ArrayList<String> propertySourceProperties = new ArrayList<String>(Arrays.asList(mergedConfig.getPropertySourceProperties()));
        String differentiator = this.getDifferentiatorPropertySourceProperty();
        if (differentiator != null) {
            propertySourceProperties.add(differentiator);
        }
        this.processPropertySourceProperties(mergedConfig, propertySourceProperties);
        return propertySourceProperties;
    }

    protected String getDifferentiatorPropertySourceProperty() {
        return ((Object)((Object)this)).getClass().getName() + "=true";
    }

    protected void processPropertySourceProperties(MergedContextConfiguration mergedConfig, List<String> propertySourceProperties) {
        Class testClass = mergedConfig.getTestClass();
        Object[] properties = this.getProperties(testClass);
        if (!ObjectUtils.isEmpty((Object[])properties)) {
            propertySourceProperties.addAll(0, Arrays.asList(properties));
        }
        if (this.getWebEnvironment(testClass) == SpringBootTest.WebEnvironment.RANDOM_PORT) {
            propertySourceProperties.add("server.port=0");
        }
    }

    protected SpringBootTest.WebEnvironment getWebEnvironment(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation == null ? null : annotation.webEnvironment();
    }

    protected Class<?>[] getClasses(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation == null ? null : annotation.classes();
    }

    protected String[] getProperties(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation == null ? null : annotation.properties();
    }

    protected SpringBootTest getAnnotation(Class<?> testClass) {
        return (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation(testClass, SpringBootTest.class);
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes) {
        return this.createModifiedConfig(mergedConfig, classes, mergedConfig.getPropertySourceProperties());
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes, String[] propertySourceProperties) {
        return new MergedContextConfiguration(mergedConfig.getTestClass(), mergedConfig.getLocations(), (Class[])classes, mergedConfig.getContextInitializerClasses(), mergedConfig.getActiveProfiles(), mergedConfig.getPropertySourceLocations(), propertySourceProperties, mergedConfig.getContextCustomizers(), mergedConfig.getContextLoader(), this.getCacheAwareContextLoaderDelegate(), mergedConfig.getParent());
    }
}

