/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.mock.MockCreationSettings;
import org.springframework.util.Assert;

@Deprecated(since="3.4.0", forRemoval=true)
public enum MockReset {
    BEFORE,
    AFTER,
    NONE;


    public static MockSettings before() {
        return MockReset.withSettings(BEFORE);
    }

    public static MockSettings after() {
        return MockReset.withSettings(AFTER);
    }

    public static MockSettings withSettings(MockReset reset) {
        return MockReset.apply(reset, Mockito.withSettings());
    }

    public static MockSettings apply(MockReset reset, MockSettings settings) {
        Assert.notNull((Object)settings, (String)"Settings must not be null");
        if (reset != null && reset != NONE) {
            settings.invocationListeners(new InvocationListener[]{new ResetInvocationListener(reset)});
        }
        return settings;
    }

    static MockReset get(Object mock) {
        MockReset reset = NONE;
        MockingDetails mockingDetails = Mockito.mockingDetails((Object)mock);
        if (mockingDetails.isMock()) {
            MockCreationSettings settings = mockingDetails.getMockCreationSettings();
            List listeners = settings.getInvocationListeners();
            for (Object listener : listeners) {
                if (!(listener instanceof ResetInvocationListener)) continue;
                ResetInvocationListener resetInvocationListener = (ResetInvocationListener)listener;
                reset = resetInvocationListener.getReset();
            }
        }
        return reset;
    }

    private static class ResetInvocationListener
    implements InvocationListener {
        private final MockReset reset;

        ResetInvocationListener(MockReset reset) {
            this.reset = reset;
        }

        MockReset getReset() {
            return this.reset;
        }

        public void reportInvocation(MethodInvocationReport methodInvocationReport) {
        }
    }
}

