/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentManager;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class UndertowEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(UndertowEmbeddedServletContainer.class);
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final boolean autoStart;
    private Undertow undertow;
    private boolean started = false;

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, int port, boolean autoStart) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.autoStart = autoStart;
    }

    @Override
    public synchronized void start() throws EmbeddedServletContainerException {
        if (!this.autoStart) {
            return;
        }
        if (this.undertow == null) {
            this.undertow = this.createUndertowServer();
        }
        this.undertow.start();
        this.started = true;
        logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription()));
    }

    private Undertow createUndertowServer() {
        try {
            HttpHandler servletHandler = this.manager.start();
            this.builder.setHandler(this.getContextHandler(servletHandler));
            return this.builder.build();
        }
        catch (ServletException ex) {
            throw new EmbeddedServletContainerException("Unable to start embdedded Undertow", ex);
        }
    }

    private HttpHandler getContextHandler(HttpHandler servletHandler) {
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return servletHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, servletHandler);
    }

    private String getPortsDescription() {
        List<Port> ports = this.getPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, (String)" ");
        }
        return "unknown";
    }

    private List<Port> getPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                Field channelsField = ReflectionUtils.findField(Undertow.class, (String)"channels");
                ReflectionUtils.makeAccessible((Field)channelsField);
                List channels = (List)ReflectionUtils.getField((Field)channelsField, (Object)this.undertow);
                for (Object channel : channels) {
                    Port port = this.getPortFromChannel(channel);
                    if (port == null) continue;
                    ports.add(port);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private Port getPortFromChannel(Object channel) {
        ServerSocket socket;
        Object tcpServer = channel;
        String protocol = "http";
        Field sslContext = ReflectionUtils.findField(channel.getClass(), (String)"sslContext");
        if (sslContext != null) {
            tcpServer = this.getTcpServer(channel);
            protocol = "https";
        }
        if ((socket = this.getSocket(tcpServer)) != null) {
            return new Port(socket.getLocalPort(), protocol);
        }
        return null;
    }

    private Object getTcpServer(Object channel) {
        Field field = ReflectionUtils.findField(channel.getClass(), (String)"tcpServer");
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)channel);
    }

    private ServerSocket getSocket(Object tcpServer) {
        Field socketField = ReflectionUtils.findField(tcpServer.getClass(), (String)"socket");
        if (socketField == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)socketField);
        return (ServerSocket)ReflectionUtils.getField((Field)socketField, (Object)tcpServer);
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        if (this.started) {
            this.started = false;
            this.undertow.stop();
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

