/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.function.Function;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;

class PropertyMapping {
    private final String propertySourceName;
    private final ConfigurationPropertyName configurationPropertyName;
    private final Function<Object, Object> valueExtractor;

    PropertyMapping(String propertySourceName, ConfigurationPropertyName configurationPropertyName) {
        this(propertySourceName, configurationPropertyName, Function.identity());
    }

    PropertyMapping(String propertySourceName, ConfigurationPropertyName configurationPropertyName, Function<Object, Object> valueExtractor) {
        this.propertySourceName = propertySourceName;
        this.configurationPropertyName = configurationPropertyName;
        this.valueExtractor = valueExtractor;
    }

    public String getPropertySourceName() {
        return this.propertySourceName;
    }

    public ConfigurationPropertyName getConfigurationPropertyName() {
        return this.configurationPropertyName;
    }

    public Function<Object, Object> getValueExtractor() {
        return this.valueExtractor;
    }

    public boolean isApplicable(ConfigurationPropertyName name) {
        return this.configurationPropertyName.equals(name);
    }
}

