/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.util.ClassUtils;

public class EntityManagerFactoryBuilder {
    private final JpaVendorAdapter jpaVendorAdapter;
    private final PersistenceUnitManager persistenceUnitManager;
    private final Map<String, Object> jpaProperties;
    private final URL persistenceUnitRootLocation;
    private EntityManagerFactoryBeanCallback callback;

    public EntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, PersistenceUnitManager persistenceUnitManager) {
        this(jpaVendorAdapter, jpaProperties, persistenceUnitManager, null);
    }

    public EntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, PersistenceUnitManager persistenceUnitManager, URL persistenceUnitRootLocation) {
        this.jpaVendorAdapter = jpaVendorAdapter;
        this.persistenceUnitManager = persistenceUnitManager;
        this.jpaProperties = new LinkedHashMap(jpaProperties);
        this.persistenceUnitRootLocation = persistenceUnitRootLocation;
    }

    public Builder dataSource(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public void setCallback(EntityManagerFactoryBeanCallback callback) {
        this.callback = callback;
    }

    @FunctionalInterface
    public static interface EntityManagerFactoryBeanCallback {
        public void execute(LocalContainerEntityManagerFactoryBean var1);
    }

    public final class Builder {
        private DataSource dataSource;
        private String[] packagesToScan;
        private String persistenceUnit;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private boolean jta;

        private Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Builder packages(String ... packagesToScan) {
            this.packagesToScan = packagesToScan;
            return this;
        }

        public Builder packages(Class<?> ... basePackageClasses) {
            HashSet<String> packages = new HashSet<String>();
            for (Class<?> type : basePackageClasses) {
                packages.add(ClassUtils.getPackageName(type));
            }
            this.packagesToScan = packages.toArray(new String[0]);
            return this;
        }

        public Builder persistenceUnit(String persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
            return this;
        }

        public Builder properties(Map<String, ?> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder jta(boolean jta) {
            this.jta = jta;
            return this;
        }

        public LocalContainerEntityManagerFactoryBean build() {
            LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
            if (EntityManagerFactoryBuilder.this.persistenceUnitManager != null) {
                entityManagerFactoryBean.setPersistenceUnitManager(EntityManagerFactoryBuilder.this.persistenceUnitManager);
            }
            if (this.persistenceUnit != null) {
                entityManagerFactoryBean.setPersistenceUnitName(this.persistenceUnit);
            }
            entityManagerFactoryBean.setJpaVendorAdapter(EntityManagerFactoryBuilder.this.jpaVendorAdapter);
            if (this.jta) {
                entityManagerFactoryBean.setJtaDataSource(this.dataSource);
            } else {
                entityManagerFactoryBean.setDataSource(this.dataSource);
            }
            entityManagerFactoryBean.setPackagesToScan(this.packagesToScan);
            entityManagerFactoryBean.getJpaPropertyMap().putAll(EntityManagerFactoryBuilder.this.jpaProperties);
            entityManagerFactoryBean.getJpaPropertyMap().putAll(this.properties);
            URL rootLocation = EntityManagerFactoryBuilder.this.persistenceUnitRootLocation;
            if (rootLocation != null) {
                entityManagerFactoryBean.setPersistenceUnitRootLocation(rootLocation.toString());
            }
            if (EntityManagerFactoryBuilder.this.callback != null) {
                EntityManagerFactoryBuilder.this.callback.execute(entityManagerFactoryBean);
            }
            return entityManagerFactoryBean;
        }
    }
}

