/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import io.netty.channel.unix.Errors;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.ChannelBindException;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerRoutes;

public class NettyWebServer
implements WebServer {
    private static final int ERROR_NO_EACCES = -13;
    private static final Predicate<HttpServerRequest> ALWAYS = request -> true;
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private final HttpServer httpServer;
    private final ReactorHttpHandlerAdapter handlerAdapter;
    private final Duration lifecycleTimeout;
    private List<NettyRouteProvider> routeProviders = Collections.emptyList();
    private DisposableServer disposableServer;

    public NettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        Assert.notNull((Object)httpServer, (String)"HttpServer must not be null");
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter must not be null");
        this.httpServer = httpServer;
        this.handlerAdapter = handlerAdapter;
        this.lifecycleTimeout = lifecycleTimeout;
    }

    public void setRouteProviders(List<NettyRouteProvider> routeProviders) {
        this.routeProviders = routeProviders;
    }

    @Override
    public void start() throws WebServerException {
        if (this.disposableServer == null) {
            try {
                this.disposableServer = this.startHttpServer();
            }
            catch (Exception ex) {
                PortInUseException.ifCausedBy(ex, ChannelBindException.class, bindException -> {
                    if (!this.isPermissionDenied(bindException.getCause())) {
                        throw new PortInUseException(bindException.localPort(), (Throwable)ex);
                    }
                });
                throw new WebServerException("Unable to start Netty", ex);
            }
            logger.info((Object)("Netty started on port(s): " + this.getPort()));
            this.startDaemonAwaitThread(this.disposableServer);
        }
    }

    private boolean isPermissionDenied(Throwable bindExceptionCause) {
        try {
            if (bindExceptionCause instanceof Errors.NativeIoException) {
                return ((Errors.NativeIoException)bindExceptionCause).expectedErr() == -13;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private DisposableServer startHttpServer() {
        HttpServer server = this.httpServer;
        server = this.routeProviders.isEmpty() ? server.handle((BiFunction)this.handlerAdapter) : server.route(this::applyRouteProviders);
        if (this.lifecycleTimeout != null) {
            return server.bindNow(this.lifecycleTimeout);
        }
        return server.bindNow();
    }

    private void applyRouteProviders(HttpServerRoutes routes) {
        for (NettyRouteProvider provider : this.routeProviders) {
            routes = (HttpServerRoutes)provider.apply(routes);
        }
        routes.route(ALWAYS, (BiFunction)this.handlerAdapter);
    }

    private void startDaemonAwaitThread(final DisposableServer disposableServer) {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                disposableServer.onDispose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        if (this.disposableServer != null) {
            if (this.lifecycleTimeout != null) {
                this.disposableServer.disposeNow(this.lifecycleTimeout);
            } else {
                this.disposableServer.disposeNow();
            }
            this.disposableServer = null;
        }
    }

    @Override
    public int getPort() {
        if (this.disposableServer != null) {
            return this.disposableServer.port();
        }
        return 0;
    }
}

