/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public class ApplicationAvailabilityBean
implements ApplicationAvailability,
ApplicationListener<AvailabilityChangeEvent<?>> {
    private final Map<Class<? extends AvailabilityState>, AvailabilityChangeEvent<?>> events = new HashMap();

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType, S defaultState) {
        Assert.notNull(stateType, (String)"StateType must not be null");
        Assert.notNull(defaultState, (String)"DefaultState must not be null");
        S state = this.getState(stateType);
        return state != null ? state : defaultState;
    }

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType) {
        AvailabilityChangeEvent<S> event = this.getLastChangeEvent(stateType);
        return event != null ? (S)event.getState() : null;
    }

    @Override
    public <S extends AvailabilityState> AvailabilityChangeEvent<S> getLastChangeEvent(Class<S> stateType) {
        return this.events.get(stateType);
    }

    public void onApplicationEvent(AvailabilityChangeEvent<?> event) {
        Class<? extends AvailabilityState> stateType = this.getStateType((AvailabilityState)event.getState());
        this.events.put(stateType, event);
    }

    private Class<? extends AvailabilityState> getStateType(AvailabilityState state) {
        if (state instanceof Enum) {
            return ((Enum)((Object)state)).getDeclaringClass();
        }
        return state.getClass();
    }
}

