/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.function.Supplier;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.context.ApplicationListener;

public interface BootstrapRegistry {
    public <T> void register(Class<T> var1, InstanceSupplier<T> var2);

    public <T> void registerIfAbsent(Class<T> var1, InstanceSupplier<T> var2);

    public <T> boolean isRegistered(Class<T> var1);

    public <T> InstanceSupplier<T> getRegisteredInstanceSupplier(Class<T> var1);

    public void addCloseListener(ApplicationListener<BootstrapContextClosedEvent> var1);

    public static interface InstanceSupplier<T> {
        public T get(BootstrapContext var1);

        public static <T> InstanceSupplier<T> of(T instance) {
            return registry -> instance;
        }

        public static <T> InstanceSupplier<T> from(Supplier<T> supplier) {
            return registry -> supplier != null ? supplier.get() : null;
        }
    }
}

