/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.nacos.config")
public class NacosConfigProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfigProperties.class);
    private String serverAddr;
    private String encode;
    private String group = "DEFAULT_GROUP";
    private String prefix;
    private String fileExtension = "properties";
    private int timeout = 3000;
    private String endpoint;
    private String namespace;
    private String accessKey;
    private String secretKey;
    private String contextPath;
    private String clusterName;
    @Value(value="${spring.application.name}")
    private String name;
    private String[] activeProfiles;
    private ConfigService configService;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void init() {
        this.activeProfiles = this.environment.getActiveProfiles();
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getName() {
        return this.name;
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public String toString() {
        return "NacosConfigProperties{serverAddr='" + this.serverAddr + '\'' + ", encode='" + this.encode + '\'' + ", group='" + this.group + '\'' + ", prefix='" + this.prefix + '\'' + ", fileExtension='" + this.fileExtension + '\'' + ", timeout=" + this.timeout + ", endpoint='" + this.endpoint + '\'' + ", namespace='" + this.namespace + '\'' + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", contextPath='" + this.contextPath + '\'' + ", clusterName='" + this.clusterName + '\'' + ", name='" + this.name + '\'' + ", activeProfiles=" + Arrays.toString(this.activeProfiles) + '}';
    }

    public ConfigService configServiceInstance() {
        if (null != this.configService) {
            return this.configService;
        }
        Properties properties = new Properties();
        properties.put("serverAddr", Objects.toString(this.serverAddr, ""));
        properties.put("encode", Objects.toString(this.encode, ""));
        properties.put("namespace", Objects.toString(this.namespace, ""));
        properties.put("accessKey", Objects.toString(this.accessKey, ""));
        properties.put("secretKey", Objects.toString(this.secretKey, ""));
        properties.put("contextPath", Objects.toString(this.contextPath, ""));
        properties.put("clusterName", Objects.toString(this.clusterName, ""));
        properties.put("endpoint", Objects.toString(this.endpoint, ""));
        try {
            this.configService = NacosFactory.createConfigService((Properties)properties);
            return this.configService;
        }
        catch (Exception e) {
            LOGGER.error("create config service error!properties={},e=,", (Object)this, (Object)e);
            return null;
        }
    }
}

