/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;

public class NacosPropertySourceRepository {
    private final ApplicationContext applicationContext;

    public NacosPropertySourceRepository(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<NacosPropertySource> getAll() {
        ArrayList<NacosPropertySource> result = new ArrayList<NacosPropertySource>();
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.applicationContext;
        for (PropertySource p : ctx.getEnvironment().getPropertySources()) {
            if (p instanceof NacosPropertySource) {
                result.add((NacosPropertySource)p);
                continue;
            }
            if (!(p instanceof CompositePropertySource)) continue;
            this.collectNacosPropertySources((CompositePropertySource)p, result);
        }
        return result;
    }

    private void collectNacosPropertySources(CompositePropertySource composite, List<NacosPropertySource> result) {
        for (PropertySource p : composite.getPropertySources()) {
            if (p instanceof NacosPropertySource) {
                result.add((NacosPropertySource)p);
                continue;
            }
            if (!(p instanceof CompositePropertySource)) continue;
            this.collectNacosPropertySources((CompositePropertySource)p, result);
        }
    }
}

