/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.endpoint;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.NacosPropertySourceRepository;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.cloud.alibaba.nacos.refresh.NacosRefreshHistory;

public class NacosConfigEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final NacosConfigProperties properties;
    private final NacosRefreshHistory refreshHistory;
    private final NacosPropertySourceRepository propertySourceRepository;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public NacosConfigEndpoint(NacosConfigProperties properties, NacosRefreshHistory refreshHistory, NacosPropertySourceRepository propertySourceRepository) {
        super("nacos_config", false);
        this.properties = properties;
        this.refreshHistory = refreshHistory;
        this.propertySourceRepository = propertySourceRepository;
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("NacosConfigProperties", this.properties);
        List<NacosPropertySource> all = this.propertySourceRepository.getAll();
        ArrayList sources = new ArrayList();
        for (NacosPropertySource ps : all) {
            HashMap<String, String> source = new HashMap<String, String>(16);
            source.put("dataId", ps.getDataId());
            source.put("lastSynced", this.dateFormat.format(ps.getTimestamp()));
            sources.add(source);
        }
        result.put("Sources", sources);
        result.put("RefreshHistory", this.refreshHistory.getRecords());
        return result;
    }
}

