/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.refresh;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.NacosPropertySourceRepository;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.cloud.alibaba.nacos.refresh.NacosRefreshHistory;
import org.springframework.cloud.alibaba.nacos.refresh.NacosRefreshProperties;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class NacosContextRefresher
implements ApplicationListener<ApplicationReadyEvent> {
    private Logger logger = LoggerFactory.getLogger(NacosContextRefresher.class);
    private final ContextRefresher contextRefresher;
    private final NacosConfigProperties properties;
    private final NacosRefreshProperties refreshProperties;
    private final NacosRefreshHistory refreshHistory;
    private final NacosPropertySourceRepository nacosPropertySourceRepository;
    private final ConfigService configService;
    private Map<String, Listener> listenerMap = new ConcurrentHashMap<String, Listener>(16);

    public NacosContextRefresher(ContextRefresher contextRefresher, NacosConfigProperties properties, NacosRefreshProperties refreshProperties, NacosRefreshHistory refreshHistory, NacosPropertySourceRepository nacosPropertySourceRepository, ConfigService configService) {
        this.contextRefresher = contextRefresher;
        this.properties = properties;
        this.refreshProperties = refreshProperties;
        this.refreshHistory = refreshHistory;
        this.nacosPropertySourceRepository = nacosPropertySourceRepository;
        this.configService = configService;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.registerNacosListenersForApplications();
    }

    private void registerNacosListenersForApplications() {
        if (this.refreshProperties.isEnabled()) {
            for (NacosPropertySource nacosPropertySource : this.nacosPropertySourceRepository.getAll()) {
                String dataId = nacosPropertySource.getDataId();
                this.registerNacosListener(dataId);
            }
        }
    }

    private void registerNacosListener(final String dataId) {
        Listener listener = this.listenerMap.computeIfAbsent(dataId, i -> new Listener(){

            public void receiveConfigInfo(String configInfo) {
                String md5 = "";
                if (!StringUtils.isEmpty((Object)configInfo)) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md5 = new BigInteger(1, md.digest(configInfo.getBytes("UTF-8"))).toString(16);
                    }
                    catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                        NacosContextRefresher.this.logger.warn("unable to get md5 for dataId: " + dataId, (Throwable)e);
                    }
                }
                NacosContextRefresher.this.refreshHistory.add(dataId, md5);
                NacosContextRefresher.this.contextRefresher.refresh();
            }

            public Executor getExecutor() {
                return null;
            }
        });
        try {
            this.configService.addListener(dataId, this.properties.getGroup(), listener);
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }
}

