/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.endpoint;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.endpoint.NacosConfigEndpoint;
import org.springframework.cloud.alibaba.nacos.endpoint.NacosConfigHealthIndicator;
import org.springframework.cloud.alibaba.nacos.refresh.NacosRefreshHistory;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnClass(value={Endpoint.class})
public class NacosConfigEndpointAutoConfiguration {
    @Autowired
    private NacosConfigProperties nacosConfigProperties;
    @Autowired
    private NacosRefreshHistory nacosRefreshHistory;

    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    @Bean
    public NacosConfigEndpoint nacosConfigEndpoint() {
        return new NacosConfigEndpoint(this.nacosConfigProperties, this.nacosRefreshHistory);
    }

    @Bean
    public NacosConfigHealthIndicator nacosConfigHealthIndicator() {
        return new NacosConfigHealthIndicator(this.nacosConfigProperties, this.nacosConfigProperties.configServiceInstance());
    }
}

