/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource;

import java.util.HashMap;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.ApolloDataSourceFactoryBean;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.FileRefreshableDataSourceFactoryBean;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.NacosDataSourceFactoryBean;
import org.springframework.cloud.alibaba.sentinel.datasource.factorybean.ZookeeperDataSourceFactoryBean;

public class SentinelDataSourceRegistry {
    private static HashMap<String, Class<? extends FactoryBean>> cache = new HashMap(32);

    public static synchronized void registerFactoryBean(String alias, Class<? extends FactoryBean> clazz) {
        cache.put(alias, clazz);
    }

    public static Class<? extends FactoryBean> getFactoryBean(String alias) {
        return cache.get(alias);
    }

    public static boolean checkFactoryBean(String alias) {
        return cache.containsKey(alias);
    }

    static {
        SentinelDataSourceRegistry.registerFactoryBean("file", FileRefreshableDataSourceFactoryBean.class);
        SentinelDataSourceRegistry.registerFactoryBean("zk", ZookeeperDataSourceFactoryBean.class);
        SentinelDataSourceRegistry.registerFactoryBean("nacos", NacosDataSourceFactoryBean.class);
        SentinelDataSourceRegistry.registerFactoryBean("apollo", ApolloDataSourceFactoryBean.class);
    }
}

