/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public abstract class PropertySourcesUtils {
    public static Map<String, Object> getSubProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        String normalizedPrefix = PropertySourcesUtils.normalizePrefix(prefix);
        for (PropertySource<?> source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || subProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                subProperties.put(subName, value);
            }
        }
        return subProperties;
    }

    public static String normalizePrefix(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }
}

