/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.alibaba.sentinel.annotation.SentinelProtect;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelProtectInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SentinelBeanPostProcessor
implements MergedBeanDefinitionPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    private ConcurrentHashMap<String, SentinelProtect> cache = new ConcurrentHashMap();

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (this.checkSentinelProtect(beanDefinition, beanType)) {
            SentinelProtect sentinelProtect = ((StandardMethodMetadata)beanDefinition.getSource()).getIntrospectedMethod().getAnnotation(SentinelProtect.class);
            this.cache.put(beanName, sentinelProtect);
        }
    }

    private boolean checkSentinelProtect(RootBeanDefinition beanDefinition, Class<?> beanType) {
        return beanType == RestTemplate.class && beanDefinition.getSource() instanceof StandardMethodMetadata && ((StandardMethodMetadata)beanDefinition.getSource()).isAnnotated(SentinelProtect.class.getName());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.cache.containsKey(beanName)) {
            StringBuilder interceptorBeanName = new StringBuilder();
            SentinelProtect sentinelProtect = this.cache.get(beanName);
            interceptorBeanName.append(StringUtils.uncapitalize((String)SentinelProtectInterceptor.class.getSimpleName())).append("_").append(sentinelProtect.blockHandlerClass().getSimpleName()).append(sentinelProtect.blockHandler()).append("_").append(sentinelProtect.fallbackClass().getSimpleName()).append(sentinelProtect.fallback());
            RestTemplate restTemplate = (RestTemplate)bean;
            this.registerBean(interceptorBeanName.toString(), sentinelProtect);
            SentinelProtectInterceptor sentinelProtectInterceptor = (SentinelProtectInterceptor)this.applicationContext.getBean(interceptorBeanName.toString(), SentinelProtectInterceptor.class);
            restTemplate.getInterceptors().add(sentinelProtectInterceptor);
        }
        return bean;
    }

    private void registerBean(String interceptorBeanName, SentinelProtect sentinelProtect) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SentinelProtectInterceptor.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)sentinelProtect);
        AbstractBeanDefinition interceptorBeanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(interceptorBeanName, (BeanDefinition)interceptorBeanDefinition);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

