/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.sentinel.annotation.SentinelProtect;
import org.springframework.cloud.alibaba.sentinel.custom.BlockClassRegistry;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ClassUtils;

public class SentinelProtectInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SentinelProtectInterceptor.class);
    private SentinelProtect sentinelProtect;

    public SentinelProtectInterceptor(SentinelProtect sentinelProtect) {
        this.sentinelProtect = sentinelProtect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        URI uri = request.getURI();
        String hostResource = uri.getScheme() + "://" + uri.getHost() + ":" + (uri.getPort() == -1 ? 80 : uri.getPort());
        String hostWithPathResource = hostResource + uri.getPath();
        Entry hostEntry = null;
        Entry hostWithPathEntry = null;
        ClientHttpResponse response = null;
        try {
            ContextUtil.enter((String)hostWithPathResource);
            hostWithPathEntry = SphU.entry((String)hostWithPathResource);
            hostEntry = SphU.entry((String)hostResource);
            response = execution.execute(request, body);
        }
        catch (BlockException e) {
            logger.error("RestTemplate block", (Throwable)e);
            try {
                this.handleBlockException(e);
            }
            catch (Exception ex) {
                logger.error("sentinel handle BlockException error.", (Throwable)e);
            }
        }
        finally {
            if (hostEntry != null) {
                hostEntry.exit();
            }
            if (hostWithPathEntry != null) {
                hostWithPathEntry.exit();
            }
            ContextUtil.exit();
        }
        return response;
    }

    private void handleBlockException(BlockException ex) throws Exception {
        Method blockHandler;
        Method method;
        Object[] args = new Object[]{ex};
        if (this.isDegradeFailure(ex) && (method = this.extractFallbackMethod(this.sentinelProtect.fallback(), this.sentinelProtect.fallbackClass())) != null) {
            method.invoke(null, args);
        }
        if ((blockHandler = this.extractBlockHandlerMethod(this.sentinelProtect.blockHandler(), this.sentinelProtect.blockHandlerClass())) != null) {
            blockHandler.invoke(null, args);
        }
    }

    private Method extractFallbackMethod(String fallback, Class<?> fallbackClass) {
        if (StringUtil.isBlank((String)fallback) || fallbackClass == Void.TYPE) {
            return null;
        }
        Method cachedMethod = BlockClassRegistry.lookupFallback(fallbackClass, fallback);
        if (cachedMethod == null) {
            cachedMethod = ClassUtils.getStaticMethod(fallbackClass, (String)fallback, (Class[])new Class[]{BlockException.class});
            BlockClassRegistry.updateFallbackFor(fallbackClass, fallback, cachedMethod);
        }
        return cachedMethod;
    }

    private Method extractBlockHandlerMethod(String block, Class<?> blockClass) {
        if (StringUtil.isBlank((String)block) || blockClass == Void.TYPE) {
            return null;
        }
        Method cachedMethod = BlockClassRegistry.lookupBlockHandler(blockClass, block);
        if (cachedMethod == null) {
            cachedMethod = ClassUtils.getStaticMethod(blockClass, (String)block, (Class[])new Class[]{BlockException.class});
            BlockClassRegistry.updateBlockHandlerFor(blockClass, block, cachedMethod);
        }
        return cachedMethod;
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }
}

