/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlBlockHandler;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.config.WebServletConfig;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alibaba.sentinel.SentinelProperties;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelBeanPostProcessor;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelDataSourceHandler;
import org.springframework.cloud.alibaba.sentinel.datasource.converter.JsonConverter;
import org.springframework.cloud.alibaba.sentinel.datasource.converter.XmlConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelAutoConfiguration {
    @Value(value="${project.name:${spring.application.name:}}")
    private String projectName;
    @Autowired
    private SentinelProperties properties;
    @Autowired
    private Optional<UrlCleaner> urlCleanerOptional;
    @Autowired
    private Optional<UrlBlockHandler> urlBlockHandlerOptional;

    @PostConstruct
    private void init() {
        if (StringUtils.isEmpty((Object)System.getProperty("project.name")) && StringUtils.hasText((String)this.projectName)) {
            System.setProperty("project.name", this.projectName);
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.api.port")) && StringUtils.hasText((String)this.properties.getTransport().getPort())) {
            System.setProperty("csp.sentinel.api.port", this.properties.getTransport().getPort());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.dashboard.server")) && StringUtils.hasText((String)this.properties.getTransport().getDashboard())) {
            System.setProperty("csp.sentinel.dashboard.server", this.properties.getTransport().getDashboard());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.heartbeat.interval.ms")) && StringUtils.hasText((String)this.properties.getTransport().getHeartbeatIntervalMs())) {
            System.setProperty("csp.sentinel.heartbeat.interval.ms", this.properties.getTransport().getHeartbeatIntervalMs());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.charset")) && StringUtils.hasText((String)this.properties.getMetric().getCharset())) {
            System.setProperty("csp.sentinel.charset", this.properties.getMetric().getCharset());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.metric.file.single.size")) && StringUtils.hasText((String)this.properties.getMetric().getFileSingleSize())) {
            System.setProperty("csp.sentinel.metric.file.single.size", this.properties.getMetric().getFileSingleSize());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.metric.file.total.count")) && StringUtils.hasText((String)this.properties.getMetric().getFileTotalCount())) {
            System.setProperty("csp.sentinel.metric.file.total.count", this.properties.getMetric().getFileTotalCount());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.flow.cold.factor")) && StringUtils.hasText((String)this.properties.getFlow().getColdFactor())) {
            System.setProperty("csp.sentinel.flow.cold.factor", this.properties.getFlow().getColdFactor());
        }
        if (StringUtils.hasText((String)this.properties.getServlet().getBlockPage())) {
            WebServletConfig.setBlockPage((String)this.properties.getServlet().getBlockPage());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.log.dir")) && StringUtils.hasText((String)this.properties.getLog().getDir())) {
            System.setProperty("csp.sentinel.log.dir", this.properties.getLog().getDir());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.log.use.pid")) && this.properties.getLog().isSwitchPid()) {
            System.setProperty("csp.sentinel.log.use.pid", String.valueOf(this.properties.getLog().isSwitchPid()));
        }
        this.urlBlockHandlerOptional.ifPresent(WebCallbackManager::setUrlBlockHandler);
        this.urlCleanerOptional.ifPresent(WebCallbackManager::setUrlCleaner);
        if (this.properties.isEager()) {
            InitExecutor.doInit();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    public SentinelBeanPostProcessor sentinelBeanPostProcessor() {
        return new SentinelBeanPostProcessor();
    }

    @Bean
    public SentinelDataSourceHandler sentinelDataSourceHandler() {
        return new SentinelDataSourceHandler();
    }

    @Bean(value={"sentinel-json-converter"})
    public JsonConverter jsonConverter() {
        return new JsonConverter(this.objectMapper());
    }

    private ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @ConditionalOnClass(value={XmlMapper.class})
    protected static class SentinelXmlConfiguration {
        protected SentinelXmlConfiguration() {
        }

        @Bean(value={"sentinel-xml-converter"})
        public XmlConverter xmlConverter() {
            return new XmlConverter(this.xmlMapper());
        }

        private XmlMapper xmlMapper() {
            return new XmlMapper();
        }
    }
}

