/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;

public class RefreshListener
implements ApplicationListener<RefreshRemoteApplicationEvent> {
    private static Log log = LogFactory.getLog(RefreshListener.class);
    private ContextRefresher contextRefresher;
    private ServiceMatcher serviceMatcher;

    @Deprecated
    public RefreshListener(ContextRefresher contextRefresher) {
        this(contextRefresher, null);
    }

    public RefreshListener(ContextRefresher contextRefresher, ServiceMatcher serviceMatcher) {
        this.contextRefresher = contextRefresher;
        this.serviceMatcher = serviceMatcher;
    }

    public void onApplicationEvent(RefreshRemoteApplicationEvent event) {
        log.info((Object)"Received remote refresh request.");
        if (this.serviceMatcher == null) {
            log.warn((Object)"RefreshListener does not have a ServiceMatcher, refresh may be performed even if the event does not target this app.  Consider passing a ServiceMatcher in the constructor");
            this.refresh();
        } else if (this.serviceMatcher.isForSelf(event)) {
            this.refresh();
        } else {
            log.info((Object)("Refresh not performed, the event was targetting " + event.getDestinationService()));
        }
    }

    private void refresh() {
        Set keys = this.contextRefresher.refresh();
        log.info((Object)("Keys refreshed " + keys));
    }
}

