/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.endpoint;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.bus.endpoint.AbstractBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.ShutdownRemoteApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

@Endpoint(id="busshutdown")
public class ShutdownBusEndpoint
extends AbstractBusEndpoint {
    public ShutdownBusEndpoint(ApplicationEventPublisher publisher, String id, Destination.Factory destinationFactory) {
        super(publisher, id, destinationFactory);
    }

    @WriteOperation
    public void busShutdownWithDestination(@Selector(match=Selector.Match.ALL_REMAINING) String[] destinations) {
        String destination = StringUtils.arrayToDelimitedString((Object[])destinations, (String)":");
        this.publish(new ShutdownRemoteApplicationEvent((Object)this, this.getInstanceId(), this.getDestination(destination)));
    }

    @WriteOperation
    public void busShutdown() {
        this.publish(new ShutdownRemoteApplicationEvent((Object)this, this.getInstanceId(), this.getDestination(null)));
    }
}

