/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.Base64Variant;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonLocation;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParseException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.ObjectCodec;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.SerializableString;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.base.ParserBase;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.CharTypes;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.IOContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.sym.Name;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.util.ArraysCompat;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.util.ByteArrayBuilder;

public class UTF8StreamJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    private static final int[] _icWS = CharTypes.getInputCodeWS();
    protected ObjectCodec _objectCodec;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete = false;
    private int _quad1;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    public UTF8StreamJsonParser(IOContext iOContext, int n, InputStream inputStream, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, byte[] byArray, int n2, int n3, boolean bl) {
        super(iOContext, n);
        this._inputStream = inputStream;
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._currInputRowStart = n2;
        this._currInputProcessed = -n2;
        this._bufferRecyclable = bl;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        outputStream.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._inputStream != null) {
            int n = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final boolean _loadToHaveAtLeast(int n) throws IOException {
        if (this._inputStream == null) {
            return false;
        }
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0 && this._inputPtr > 0) {
            this._currInputProcessed += (long)this._inputPtr;
            this._currInputRowStart -= this._inputPtr;
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
            this._inputEnd = n2;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n) {
            int n3 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                this._closeInput();
                if (n3 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n2 + " bytes");
                }
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        byte[] byArray;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public String getValueAsString() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(string);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException, JsonParseException {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                if (n4 == 34) break;
                n5 = this._decodeBase64Escape(base64Variant, n4, 0);
                if (n5 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream.write(byArray, 0, n);
                n = 0;
            }
            int n6 = n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n5 = this._decodeBase64Escape(base64Variant, n4, 1);
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n5 != -2) {
                    if (n4 == 34 && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)(n6 >>= 4);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 2);
                }
                if (n5 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n4, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n6 >>= 4);
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n5 != -2) {
                    if (n4 == 34 && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)((n6 >>= 2) >> 8);
                        byArray[n++] = (byte)n6;
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 3);
                }
                if (n5 == -2) {
                    byArray[n++] = (byte)((n6 >>= 2) >> 8);
                    byArray[n++] = (byte)n6;
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            byArray[n++] = (byte)(n6 >> 16);
            byArray[n++] = (byte)(n6 >> 8);
            byArray[n++] = (byte)n6;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this.getTokenCharacterOffset(), -1L, this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._ioContext.getSourceReference(), this._currInputProcessed + (long)this._inputPtr, -1L, this._currInputRow, n);
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken jsonToken;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n);
        }
        Name name = this._parseName(n);
        this._parsingContext.setCurrentName(name.getName());
        this._currToken = JsonToken.FIELD_NAME;
        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 58) {
            ++this._inputPtr;
        } else {
            n = this._skipWS();
            if (n != 58) {
                this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
            }
        }
        n = this._skipWS();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseNumber(n);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n) throws IOException, JsonParseException {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parseNumber(n);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException, JsonParseException {
        int n;
        byte[] byArray;
        int n2;
        int n3;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n3 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n3 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n3, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (n3 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n3, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return false;
        }
        if (this._parsingContext.expectComma()) {
            if (n3 != 44) {
                this._reportUnexpectedChar(n3, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n3 = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n3);
            return false;
        }
        if (n3 == 34 && this._inputPtr + (n2 = (byArray = serializableString.asQuotedUTF8()).length) < this._inputEnd && this._inputBuffer[n = this._inputPtr + n2] == 34) {
            int n4 = 0;
            int n5 = this._inputPtr;
            while (true) {
                if (n4 == n2) {
                    this._inputPtr = n + 1;
                    this._parsingContext.setCurrentName(serializableString.getValue());
                    this._currToken = JsonToken.FIELD_NAME;
                    this._isNextTokenNameYes();
                    return true;
                }
                if (byArray[n4] != this._inputBuffer[n5 + n4]) break;
                ++n4;
            }
        }
        return this._isNextTokenNameMaybe(n3, serializableString);
    }

    private final void _isNextTokenNameYes() throws IOException, JsonParseException {
        int n;
        if (this._inputPtr < this._inputEnd - 1 && this._inputBuffer[this._inputPtr] == 58) {
            n = this._inputBuffer[++this._inputPtr];
            ++this._inputPtr;
            if (n == 34) {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            if (n == 123) {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            if (n == 91) {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            if ((n &= 0xFF) <= 32 || n == 47) {
                --this._inputPtr;
                n = this._skipWS();
            }
        } else {
            n = this._skipColon();
        }
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchToken("false", 1);
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchToken("null", 1);
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._nextToken = this._parseNumber(n);
                return;
            }
        }
        this._nextToken = this._handleUnexpectedValue(n);
    }

    private final boolean _isNextTokenNameMaybe(int n, SerializableString serializableString) throws IOException, JsonParseException {
        Name name = this._parseName(n);
        Object object = name.getName();
        this._parsingContext.setCurrentName((String)object);
        boolean bl = object.equals(serializableString.getValue());
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipWS();
        if (n != 58) {
            this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
        }
        if ((n = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return bl;
        }
        switch (n) {
            case 91: {
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                object = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this._parseNumber(n);
                break;
            }
            default: {
                object = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = object;
        return bl;
    }

    @Override
    public String nextTextValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    @Override
    public long nextLongValue(long l) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        switch (this.nextToken().id()) {
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected JsonToken _parseNumber(int n) throws IOException, JsonParseException {
        boolean bl;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        boolean bl2 = bl = n == 45;
        if (bl) {
            cArray[n2++] = 45;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n > 57) {
                return this._handleInvalidNumberStart(n, true);
            }
        }
        if (n == 48) {
            n = this._verifyNoLeadingZeroes();
        }
        cArray[n2++] = (char)n;
        int n3 = 1;
        int n4 = this._inputPtr + cArray.length;
        if (n4 > this._inputEnd) {
            n4 = this._inputEnd;
        }
        while (true) {
            if (this._inputPtr >= n4) {
                return this._parserNumber2(cArray, n2, bl, n3);
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n > 57) break;
            ++n3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n;
        }
        if (n == 46 || n == 101 || n == 69) {
            return this._parseFloat(cArray, n2, n, bl, n3);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        return this.resetInt(bl, n3);
    }

    private final JsonToken _parserNumber2(char[] cArray, int n, boolean bl, int n2) throws IOException, JsonParseException {
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuffer.setCurrentLength(n);
                return this.resetInt(bl, n2);
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || n3 < 48) {
                if (n3 != 46 && n3 != 101 && n3 != 69) break;
                return this._parseFloat(cArray, n, n3, bl, n2);
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n3;
            ++n2;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(this._inputBuffer[this._inputPtr++] & 0xFF);
        }
        return this.resetInt(bl, n2);
    }

    private final int _verifyNoLeadingZeroes() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return 48;
        }
        int n = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n < 48 || n > 57) {
            return 48;
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n == 48) {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                n = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n < 48 || n > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n == 48) continue;
                break;
            }
        }
        return n;
    }

    private final JsonToken _parseFloat(char[] cArray, int n, int n2, boolean bl, int n3) throws IOException, JsonParseException {
        int n4 = 0;
        boolean bl2 = false;
        if (n2 == 46) {
            cArray[n++] = (char)n2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n2 == 43) {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n5;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(n2);
            }
        }
        this._textBuffer.setCurrentLength(n);
        return this.resetFloat(bl, n3, n4, n5);
    }

    private final void _verifyRootSpace(int n) throws IOException {
        ++this._inputPtr;
        switch (n) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n);
    }

    protected Name _parseName(int n) throws IOException {
        int n2;
        if (n != 34) {
            return this._handleOddName(n);
        }
        if (this._inputPtr + 9 > this._inputEnd) {
            return this.slowParseName();
        }
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
            if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                n2 = n2 << 8 | n;
                if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                    n2 = n2 << 8 | n;
                    if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                        n2 = n2 << 8 | n;
                        if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                            this._quad1 = n2;
                            return this.parseMediumName(n, nArray);
                        }
                        if (n == 34) {
                            return this.findName(n2, 4);
                        }
                        return this.parseName(n2, n, 4);
                    }
                    if (n == 34) {
                        return this.findName(n2, 3);
                    }
                    return this.parseName(n2, n, 3);
                }
                if (n == 34) {
                    return this.findName(n2, 2);
                }
                return this.parseName(n2, n, 2);
            }
            if (n == 34) {
                return this.findName(n2, 1);
            }
            return this.parseName(n2, n, 1);
        }
        if (n2 == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseName(0, n2, 0);
    }

    protected Name parseMediumName(int n, int[] nArray) throws IOException {
        int n2;
        if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 1);
            }
            return this.parseName(this._quad1, n, n2, 1);
        }
        n = n << 8 | n2;
        if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 2);
            }
            return this.parseName(this._quad1, n, n2, 2);
        }
        n = n << 8 | n2;
        if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 3);
            }
            return this.parseName(this._quad1, n, n2, 3);
        }
        n = n << 8 | n2;
        if (nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 4);
            }
            return this.parseName(this._quad1, n, n2, 4);
        }
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n;
        return this.parseLongName(n2);
    }

    protected Name parseLongName(int n) throws IOException {
        int[] nArray = _icLatin1;
        int n2 = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            int n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n2, n, n3, 1);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n2, n, n3, 2);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n2, n, n3, 3);
            }
            n = n << 8 | n3;
            if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n3 == 34) {
                    return this.findName(this._quadBuffer, n2, n, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n2, n, n3, 4);
            }
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, n2);
            }
            this._quadBuffer[n2++] = n;
            n = n3;
        }
        return this.parseEscapedName(this._quadBuffer, n2, 0, n, 0);
    }

    protected Name slowParseName() throws IOException {
        int n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedName(this._quadBuffer, 0, 0, n, 0);
    }

    private final Name parseName(int n, int n2, int n3) throws IOException {
        return this.parseEscapedName(this._quadBuffer, 0, n, n2, n3);
    }

    private final Name parseName(int n, int n2, int n3, int n4) throws IOException {
        this._quadBuffer[0] = n;
        return this.parseEscapedName(this._quadBuffer, 1, n2, n3, n4);
    }

    protected Name parseEscapedName(int[] nArray, int n, int n2, int n3, int n4) throws IOException {
        Name name;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n3] != 0) {
                if (n3 == 34) break;
                if (n3 != 92) {
                    this._throwUnquotedSpace(n3, "name");
                } else {
                    n3 = this._decodeEscaped();
                }
                if (n3 > 127) {
                    if (n4 >= 4) {
                        if (n >= nArray.length) {
                            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n4 = 0;
                    }
                    if (n3 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n3 >> 6);
                        ++n4;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n3 >> 12);
                        if (++n4 >= 4) {
                            if (n >= nArray.length) {
                                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n4 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n3 >> 6 & 0x3F);
                        ++n4;
                    }
                    n3 = 0x80 | n3 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n2 = n2 << 8 | n3;
            } else {
                if (n >= nArray.length) {
                    nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n++] = n2;
                n2 = n3;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n >= nArray.length) {
                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n++] = n2;
        }
        if ((name = this._symbols.findName(nArray, n)) == null) {
            name = this.addName(nArray, n, n4);
        }
        return name;
    }

    protected Name _handleOddName(int n) throws IOException {
        Name name;
        int[] nArray;
        if (n == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseAposName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n] != 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                nArray2[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            if (nArray[n = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n4 > 0) {
            if (n2 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n2++] = n3;
        }
        if ((name = this._symbols.findName(nArray2, n2)) == null) {
            name = this.addName(nArray2, n2, n4);
        }
        return name;
    }

    protected Name _parseAposName() throws IOException {
        Name name;
        int n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for name");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        int[] nArray = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray2 = _icLatin1;
        while (n != 39) {
            if (n != 34 && nArray2[n] != 0) {
                if (n != 92) {
                    this._throwUnquotedSpace(n, "name");
                } else {
                    n = this._decodeEscaped();
                }
                if (n > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (n < 2048) {
                        n3 = n3 << 8 | (0xC0 | n >> 6);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n >> 12);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n4 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n >> 6 & 0x3F);
                        ++n4;
                    }
                    n = 0x80 | n & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = n3;
        }
        if ((name = this._symbols.findName(nArray, n2)) == null) {
            name = this.addName(nArray, n2, n4);
        }
        return name;
    }

    private final Name findName(int n, int n2) throws JsonParseException {
        Name name = this._symbols.findName(n);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n;
        return this.addName(this._quadBuffer, 1, n2);
    }

    private final Name findName(int n, int n2, int n3) throws JsonParseException {
        Name name = this._symbols.findName(n, n2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.addName(this._quadBuffer, 2, n3);
    }

    private final Name findName(int[] nArray, int n, int n2, int n3) throws JsonParseException {
        if (n >= nArray.length) {
            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n++] = n2;
        Name name = this._symbols.findName(nArray, n);
        if (name == null) {
            return this.addName(nArray, n, n3);
        }
        return name;
    }

    private final Name addName(int[] nArray, int n, int n2) throws JsonParseException {
        int n3;
        int n4 = (n << 2) - 4 + n2;
        if (n2 < 4) {
            n3 = nArray[n - 1];
            nArray[n - 1] = n3 << (4 - n2 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n4) {
                    this._reportInvalidEOF(" in field name");
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n2 < 4) {
            nArray[n - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n);
    }

    @Override
    protected void _finishString() throws IOException {
        int n = this._inputPtr;
        if (n >= this._inputEnd) {
            this.loadMoreGuaranteed();
            n = this._inputPtr;
        }
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = Math.min(this._inputEnd, n + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n < n3) {
            int n4 = byArray[n] & 0xFF;
            if (nArray[n4] != 0) {
                if (n4 != 34) break;
                this._inputPtr = n + 1;
                this._textBuffer.setCurrentLength(n2);
                return;
            }
            ++n;
            cArray[n2++] = (char)n4;
        }
        this._inputPtr = n;
        this._finishString2(cArray, n2);
    }

    private final void _finishString2(char[] cArray, int n) throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n2;
            int n3;
            block15: {
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                int n4 = Math.min(this._inputEnd, n3 + (cArray.length - n));
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                        break;
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n;
            int n2;
            block10: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            if (n == 34) break;
            switch (nArray[n]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block6;
                }
            }
            if (n < 32) {
                this._throwUnquotedSpace(n, "string value");
                continue;
            }
            this._reportInvalidChar(n);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n) throws IOException {
        switch (n) {
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++] & 0xFF, false);
            }
        }
        if (Character.isJavaIdentifierStart(n)) {
            this._reportInvalidToken("" + (char)n, "('true', 'false' or 'null')");
        }
        this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        int n = 0;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n3;
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            if ((n4 = this._inputPtr + (cArray.length - n2)) < (n3 = this._inputEnd)) {
                n3 = n4;
            }
            while (true) {
                if (this._inputPtr >= n3) continue block6;
                if ((n = byArray[this._inputPtr++] & 0xFF) == 39 || nArray[n] != 0) break;
                cArray[n2++] = (char)n;
            }
            if (n == 39) break;
            switch (nArray[n]) {
                case 1: {
                    if (n == 39) break;
                    n = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n = this._decodeUtf8_2(n);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n = this._decodeUtf8_3fast(n);
                        break;
                    }
                    n = this._decodeUtf8_3(n);
                    break;
                }
                case 4: {
                    n = this._decodeUtf8_4(n);
                    cArray[n2++] = (char)(0xD800 | n >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n = 0xDC00 | n & 0x3FF;
                    break;
                }
                default: {
                    if (n < 32) {
                        this._throwUnquotedSpace(n, "string value");
                    }
                    this._reportInvalidChar(n);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) throws IOException {
        while (n == 73) {
            String string;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl ? "-INF" : "+INF";
            } else {
                if (n != 110) break;
                string = bl ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected void _matchToken(String string, int n) throws IOException {
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        int n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 < 48 || n3 == 93 || n3 == 125) {
            return;
        }
        char c = (char)this._decodeCharForError(n3);
        if (Character.isJavaIdentifierPart(c)) {
            this._reportInvalidToken(string.substring(0, n));
        }
    }

    private final int _skipWS() throws IOException {
        int[] nArray = _icWS;
        block11: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (nArray[n]) {
                case 0: {
                    return n;
                }
                case 1: {
                    continue block11;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block11;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block11;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block11;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    continue block11;
                }
                case 13: {
                    this._skipCR();
                    continue block11;
                }
                case 47: {
                    this._skipComment();
                    continue block11;
                }
                case 35: {
                    if (this._skipYAMLComment()) continue block11;
                    return n;
                }
            }
            if (n < 32) {
                this._throwInvalidSpace(n);
            }
            this._reportInvalidChar(n);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException {
        int[] nArray = _icWS;
        block11: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (nArray[n]) {
                case 0: {
                    return n;
                }
                case 1: {
                    continue block11;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block11;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block11;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block11;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    continue block11;
                }
                case 13: {
                    this._skipCR();
                    continue block11;
                }
                case 47: {
                    this._skipComment();
                    continue block11;
                }
                case 35: {
                    if (this._skipYAMLComment()) continue block11;
                    return n;
                }
            }
            this._reportInvalidChar(n);
        }
        this._handleEOF();
        return -1;
    }

    private final int _skipColon() throws IOException {
        int n;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = this._inputBuffer[this._inputPtr++]) == 58) {
            if (this._inputPtr < this._inputEnd && (n = this._inputBuffer[this._inputPtr] & 0xFF) > 32 && n != 47) {
                ++this._inputPtr;
                return n;
            }
        } else {
            n &= 0xFF;
            block6: while (true) {
                switch (n) {
                    case 9: 
                    case 32: {
                        break;
                    }
                    case 13: {
                        this._skipCR();
                        break;
                    }
                    case 10: {
                        ++this._currInputRow;
                        this._currInputRowStart = this._inputPtr;
                        break;
                    }
                    case 47: {
                        this._skipComment();
                        break;
                    }
                    default: {
                        if (n >= 32) break block6;
                        this._throwInvalidSpace(n);
                        break block6;
                    }
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                n = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n != 58) {
                this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
            }
        }
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n != 47) {
                    return n;
                }
                this._skipComment();
                continue;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final void _skipComment() throws IOException {
        int n;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipLine();
        } else if (n == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    break;
                }
                case 13: {
                    this._skipCR();
                    break;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    break;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    break;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    break;
                }
                default: {
                    this._reportInvalidChar(n);
                }
            }
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final boolean _skipYAMLComment() throws IOException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_YAML_COMMENTS)) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block8;
                }
            }
            if (n2 >= 0) continue;
            this._reportInvalidChar(n);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte by = this._inputBuffer[this._inputPtr++];
        switch (by) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by));
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byte by2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    protected int _decodeCharForError(int n) throws IOException {
        int n2 = n;
        if (n2 < 0) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this.nextByte();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this.nextByte();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this.nextByte();
                    if ((n4 & 0xC0) != 128) {
                        this._reportInvalidOther(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int _decodeUtf8_2(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_3fast(int n) throws IOException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_4(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    private final void _skipUtf8_2(int n) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3(int n) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidToken(String string) throws IOException {
        this._reportInvalidToken(string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException {
        byte by;
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(by = this._inputBuffer[this._inputPtr++]))) {
            stringBuilder.append(c);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string2);
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    public static int[] growArrayBy(int[] nArray, int n) {
        if (nArray == null) {
            return new int[n];
        }
        return ArraysCompat.copyOf(nArray, nArray.length + n);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, n, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, n, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n3 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }
}

