/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.util.Arrays;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.Base64Variants;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.ValueNode;

public class BinaryNode
extends ValueNode {
    static final BinaryNode EMPTY_BINARY_NODE = new BinaryNode(new byte[0]);
    protected final byte[] _data;

    public BinaryNode(byte[] byArray) {
        this._data = byArray;
    }

    public BinaryNode(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            this._data = byArray;
        } else {
            this._data = new byte[n2];
            System.arraycopy(byArray, n, this._data, 0, n2);
        }
    }

    public static BinaryNode valueOf(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray);
    }

    public static BinaryNode valueOf(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        if (n2 == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray, n, n2);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BINARY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        return this._data;
    }

    @Override
    public String asText() {
        return Base64Variants.getDefaultVariant().encode(this._data, false);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), this._data, 0, this._data.length);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BinaryNode)) {
            return false;
        }
        return Arrays.equals(((BinaryNode)object)._data, this._data);
    }

    public int hashCode() {
        return this._data == null ? -1 : this._data.length;
    }

    @Override
    public String toString() {
        return Base64Variants.getDefaultVariant().encode(this._data, true);
    }
}

