/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.SerializedString;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.BeanDescription;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.PropertyName;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.type.ClassKey;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedString findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        Serializable serializable;
        ClassKey classKey = new ClassKey(clazz);
        Object object = this;
        synchronized (object) {
            if (this._rootNames == null) {
                this._rootNames = new LRUMap(20, 200);
            } else {
                serializable = (SerializedString)this._rootNames.get(classKey);
                if (serializable != null) {
                    return serializable;
                }
            }
        }
        object = mapperConfig.introspectClassAnnotations(clazz);
        serializable = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = ((BeanDescription)object).getClassInfo();
        PropertyName propertyName = ((AnnotationIntrospector)serializable).findRootName(annotatedClass);
        String string = propertyName == null || !propertyName.hasSimpleName() ? clazz.getSimpleName() : propertyName.getSimpleName();
        SerializedString serializedString = new SerializedString(string);
        RootNameLookup rootNameLookup = this;
        synchronized (rootNameLookup) {
            this._rootNames.put(classKey, serializedString);
        }
        return serializedString;
    }
}

