/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.common.AmqpServiceInfo;

public class AmqpServiceInfoCreator
extends CloudFoundryServiceInfoCreator<AmqpServiceInfo> {
    public AmqpServiceInfoCreator() {
        super(new Tags("rabbitmq"), "amqp", "amqps");
    }

    public AmqpServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String id = this.getId(serviceData);
        String uri = this.getUriFromCredentials(credentials);
        String managementUri = this.getStringFromCredentials(credentials, "http_api_uri");
        if (credentials.containsKey("uris")) {
            List uris = (List)credentials.get("uris");
            List managementUris = (List)credentials.get("http_api_uris");
            return new AmqpServiceInfo(id, uri, managementUri, uris, managementUris);
        }
        return new AmqpServiceInfo(id, uri, managementUri);
    }
}

