/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class DefaultServiceInstance
implements ServiceInstance {
    private final String serviceId;
    private final String host;
    private final int port;
    private final boolean secure;
    private final Map<String, String> metadata;

    public DefaultServiceInstance(String serviceId, String host, int port, boolean secure) {
        this(serviceId, host, port, secure, new LinkedHashMap<String, String>());
    }

    @Override
    public URI getUri() {
        return DefaultServiceInstance.getUri(this);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static URI getUri(ServiceInstance instance) {
        String scheme = instance.isSecure() ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, instance.getHost(), instance.getPort());
        return URI.create(uri);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultServiceInstance)) {
            return false;
        }
        DefaultServiceInstance other = (DefaultServiceInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultServiceInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isSecure() ? 79 : 97);
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultServiceInstance(serviceId=" + this.getServiceId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", secure=" + this.isSecure() + ", metadata=" + this.getMetadata() + ")";
    }

    @ConstructorProperties(value={"serviceId", "host", "port", "secure", "metadata"})
    public DefaultServiceInstance(String serviceId, String host, int port, boolean secure, Map<String, String> metadata) {
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.metadata = metadata;
    }
}

