/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryException;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RetryLoadBalancerInterceptor
implements ClientHttpRequestInterceptor {
    private LoadBalancedRetryPolicyFactory lbRetryPolicyFactory;
    private RetryTemplate retryTemplate;
    private LoadBalancerClient loadBalancer;
    private LoadBalancerRetryProperties lbProperties;
    private LoadBalancerRequestFactory requestFactory;
    private LoadBalancedBackOffPolicyFactory backOffPolicyFactory;
    private LoadBalancedRetryListenerFactory retryListenerFactory;

    @Deprecated
    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, LoadBalancerRetryProperties lbProperties, LoadBalancedRetryPolicyFactory lbRetryPolicyFactory, LoadBalancerRequestFactory requestFactory) {
        this.loadBalancer = loadBalancer;
        this.lbRetryPolicyFactory = lbRetryPolicyFactory;
        this.lbProperties = lbProperties;
        this.requestFactory = requestFactory;
        this.backOffPolicyFactory = new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory();
        this.retryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();
    }

    @Deprecated
    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, LoadBalancerRetryProperties lbProperties, LoadBalancedRetryPolicyFactory lbRetryPolicyFactory, LoadBalancerRequestFactory requestFactory, LoadBalancedBackOffPolicyFactory backOffPolicyFactory) {
        this.loadBalancer = loadBalancer;
        this.lbRetryPolicyFactory = lbRetryPolicyFactory;
        this.lbProperties = lbProperties;
        this.requestFactory = requestFactory;
        this.backOffPolicyFactory = backOffPolicyFactory;
        this.retryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();
    }

    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, LoadBalancerRetryProperties lbProperties, LoadBalancedRetryPolicyFactory lbRetryPolicyFactory, LoadBalancerRequestFactory requestFactory, LoadBalancedBackOffPolicyFactory backOffPolicyFactory, LoadBalancedRetryListenerFactory retryListenerFactory) {
        this.loadBalancer = loadBalancer;
        this.lbRetryPolicyFactory = lbRetryPolicyFactory;
        this.lbProperties = lbProperties;
        this.requestFactory = requestFactory;
        this.backOffPolicyFactory = backOffPolicyFactory;
        this.retryListenerFactory = retryListenerFactory;
    }

    public ClientHttpResponse intercept(final HttpRequest request, final byte[] body, final ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        final String serviceName = originalUri.getHost();
        Assert.state((serviceName != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        final LoadBalancedRetryPolicy retryPolicy = this.lbRetryPolicyFactory.create(serviceName, this.loadBalancer);
        RetryTemplate template = this.retryTemplate == null ? new RetryTemplate() : this.retryTemplate;
        BackOffPolicy backOffPolicy = this.backOffPolicyFactory.createBackOffPolicy(serviceName);
        template.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        template.setThrowLastExceptionOnExhausted(true);
        RetryListener[] retryListeners = this.retryListenerFactory.createRetryListeners(serviceName);
        if (retryListeners != null && retryListeners.length != 0) {
            template.setListeners(retryListeners);
        }
        template.setRetryPolicy((RetryPolicy)(!this.lbProperties.isEnabled() || retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(request, retryPolicy, this.loadBalancer, serviceName)));
        return (ClientHttpResponse)template.execute((RetryCallback)new RetryCallback<ClientHttpResponse, IOException>(){

            public ClientHttpResponse doWithRetry(RetryContext context) throws IOException {
                ServiceInstance serviceInstance = null;
                if (context instanceof LoadBalancedRetryContext) {
                    LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                    serviceInstance = lbContext.getServiceInstance();
                }
                if (serviceInstance == null) {
                    serviceInstance = RetryLoadBalancerInterceptor.this.loadBalancer.choose(serviceName);
                }
                ClientHttpResponse response = RetryLoadBalancerInterceptor.this.loadBalancer.execute(serviceName, serviceInstance, RetryLoadBalancerInterceptor.this.requestFactory.createRequest(request, body, execution));
                int statusCode = response.getRawStatusCode();
                if (retryPolicy != null && retryPolicy.retryableStatusCode(statusCode)) {
                    ClientHttpResponseWrapper wrapper = new ClientHttpResponseWrapper(response);
                    wrapper.init();
                    throw new RetryableStatusCodeException(serviceName, statusCode, wrapper, null);
                }
                return response;
            }
        }, (RecoveryCallback)new RecoveryCallback<ClientHttpResponse>(){

            public ClientHttpResponse recover(RetryContext retryContext) throws Exception {
                Throwable lastThrowable = retryContext.getLastThrowable();
                if (lastThrowable != null && lastThrowable instanceof RetryableStatusCodeException) {
                    RetryableStatusCodeException ex = (RetryableStatusCodeException)lastThrowable;
                    return (ClientHttpResponse)ex.getResponse();
                }
                throw new RetryException("Could not recover", lastThrowable);
            }
        });
    }

    public static class ClientHttpResponseWrapper
    implements ClientHttpResponse {
        private ClientHttpResponse response;
        private InputStream content;

        public ClientHttpResponseWrapper(ClientHttpResponse response) {
            this.response = response;
        }

        public void init() throws IOException {
            InputStream body = this.response.getBody();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = body.read(buffer)) != -1) {
                temp.write(buffer, 0, length);
            }
            this.content = new ByteArrayInputStream(temp.toByteArray());
            this.response.close();
        }

        public HttpStatus getStatusCode() throws IOException {
            return this.response.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public void close() {
            this.response.close();
        }

        public InputStream getBody() throws IOException {
            return this.content;
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

