/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.core.style.ToStringCreator;

public class RetryableRequestContext
extends DefaultRequestContext {
    private ServiceInstance previousServiceInstance;

    public RetryableRequestContext(ServiceInstance previousServiceInstance) {
        this.previousServiceInstance = previousServiceInstance;
    }

    public RetryableRequestContext(ServiceInstance previousServiceInstance, String hint) {
        super(hint);
        this.previousServiceInstance = previousServiceInstance;
    }

    public ServiceInstance getPreviousServiceInstance() {
        return this.previousServiceInstance;
    }

    public void setPreviousServiceInstance(ServiceInstance previousServiceInstance) {
        this.previousServiceInstance = previousServiceInstance;
    }

    @Override
    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("previousServiceInstance", (Object)this.previousServiceInstance);
        return to.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetryableRequestContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RetryableRequestContext context = (RetryableRequestContext)o;
        return Objects.equals(this.previousServiceInstance, context.previousServiceInstance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.previousServiceInstance);
    }
}

