/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.transport.URIish;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;
import org.springframework.cloud.config.server.ssh.SshUri;
import org.springframework.cloud.config.server.ssh.SshUriProperties;

public class SshUriPropertyProcessor {
    private final SshUriProperties sshUriProperties;

    public SshUriPropertyProcessor(SshUriProperties sshUriProperties) {
        this.sshUriProperties = sshUriProperties;
    }

    public Map<String, SshUri> getSshKeysByHostname() {
        return this.extractNestedProperties(this.sshUriProperties);
    }

    private Map<String, SshUri> extractNestedProperties(SshUriProperties uriProperties) {
        Map<String, SshUriProperties.SshUriNestedRepoProperties> repos;
        HashMap<String, SshUri> sshUriPropertyMap = new HashMap<String, SshUri>();
        String parentUri = uriProperties.getUri();
        if (SshPropertyValidator.isSshUri(parentUri) && SshUriPropertyProcessor.getHostname(parentUri) != null) {
            sshUriPropertyMap.put(SshUriPropertyProcessor.getHostname(parentUri), uriProperties);
        }
        if ((repos = uriProperties.getRepos()) != null) {
            for (SshUriProperties.SshUriNestedRepoProperties repoProperties : repos.values()) {
                String repoUri = repoProperties.getUri();
                if (!SshPropertyValidator.isSshUri(repoUri) || SshUriPropertyProcessor.getHostname(repoUri) == null) continue;
                sshUriPropertyMap.put(SshUriPropertyProcessor.getHostname(repoUri), repoProperties);
            }
        }
        return sshUriPropertyMap;
    }

    protected static String getHostname(String uri) {
        try {
            URIish urIish = new URIish(uri);
            return urIish.getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

