/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Map;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.FS;
import org.springframework.cloud.config.server.ssh.SshUri;

public class PropertyBasedSshSessionFactory
extends JschConfigSessionFactory {
    private static final String STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    private static final String PREFERRED_AUTHENTICATIONS = "PreferredAuthentications";
    private static final String YES_OPTION = "yes";
    private static final String NO_OPTION = "no";
    private static final String SERVER_HOST_KEY = "server_host_key";
    private final Map<String, SshUri> sshKeysByHostname;
    private final JSch jSch;

    public PropertyBasedSshSessionFactory(Map<String, SshUri> sshKeysByHostname, JSch jSch) {
        this.sshKeysByHostname = sshKeysByHostname;
        this.jSch = jSch;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        SshUri sshProperties = this.sshKeysByHostname.get(hc.getHostName());
        String hostKeyAlgorithm = sshProperties.getHostKeyAlgorithm();
        if (hostKeyAlgorithm != null) {
            session.setConfig(SERVER_HOST_KEY, hostKeyAlgorithm);
        }
        if (sshProperties.getHostKey() == null || !sshProperties.isStrictHostKeyChecking()) {
            session.setConfig(STRICT_HOST_KEY_CHECKING, NO_OPTION);
        } else {
            session.setConfig(STRICT_HOST_KEY_CHECKING, YES_OPTION);
        }
        String preferredAuthentications = sshProperties.getPreferredAuthentications();
        if (preferredAuthentications != null) {
            session.setConfig(PREFERRED_AUTHENTICATIONS, preferredAuthentications);
        }
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        if (this.sshKeysByHostname.containsKey(host)) {
            SshUri sshUriProperties = this.sshKeysByHostname.get(host);
            this.jSch.addIdentity(host, sshUriProperties.getPrivateKey().getBytes(), null, null);
            if (sshUriProperties.getKnownHostsFile() != null) {
                this.jSch.setKnownHosts(sshUriProperties.getKnownHostsFile());
            }
            if (sshUriProperties.getHostKey() != null) {
                HostKey hostkey = new HostKey(host, Base64.decode((String)sshUriProperties.getHostKey()));
                this.jSch.getHostKeyRepository().add(hostkey, null);
            }
            return this.jSch.getSession(user, host, port);
        }
        throw new JSchException("no keys configured for hostname " + host);
    }
}

