/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.composite;

import java.lang.reflect.Type;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.server.composite.CompositeUtils;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.support.EnvironmentRepositoryProperties;
import org.springframework.core.env.Environment;

public class CompositeEnvironmentBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Environment environment;

    public CompositeEnvironmentBeanFactoryPostProcessor(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        List<String> typePropertyList = CompositeUtils.getCompositeTypeList(this.environment);
        for (int i = 0; i < typePropertyList.size(); ++i) {
            String type = typePropertyList.get(i);
            String factoryName = CompositeUtils.getFactoryName(type, beanFactory);
            Type[] factoryTypes = CompositeUtils.getEnvironmentRepositoryFactoryTypeParams(beanFactory, factoryName);
            Class propertiesClass = (Class)factoryTypes[1];
            Object properties = this.bindProperties(i, propertiesClass, this.environment);
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(EnvironmentRepository.class).setFactoryMethodOnBean("build", factoryName).addConstructorArgValue(properties).getBeanDefinition();
            String beanName = String.format("%s-env-repo%d", type, i);
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private <P extends EnvironmentRepositoryProperties> P bindProperties(int index, Class<P> propertiesClass, Environment environment) {
        Binder binder = Binder.get((Environment)environment);
        String environmentConfigurationPropertyName = String.format("spring.cloud.config.server.composite[%d]", index);
        EnvironmentRepositoryProperties properties = (EnvironmentRepositoryProperties)binder.bind(environmentConfigurationPropertyName, propertiesClass).orElseCreate(propertiesClass);
        properties.setOrder(index + 1);
        return (P)properties;
    }
}

