/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectIdBuilder;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JsonS3ConfigFile;
import org.springframework.cloud.config.server.environment.PropertyS3ConfigFile;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.environment.YamlS3ConfigFile;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class AwsS3EnvironmentRepository
implements EnvironmentRepository,
Ordered,
SearchPathLocator {
    private static final String AWS_S3_RESOURCE_SCHEME = "s3://";
    private static final String PATH_SEPARATOR = "/";
    private final AmazonS3 s3Client;
    private final String bucketName;
    private final ConfigServerProperties serverProperties;
    protected int order = Integer.MAX_VALUE;

    public AwsS3EnvironmentRepository(AmazonS3 s3Client, String bucketName, ConfigServerProperties server) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.serverProperties = server;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Environment findOne(String specifiedApplication, String specifiedProfiles, String specifiedLabel) {
        String application = StringUtils.isEmpty((Object)specifiedApplication) ? this.serverProperties.getDefaultApplicationName() : specifiedApplication;
        String profiles = StringUtils.isEmpty((Object)specifiedProfiles) ? this.serverProperties.getDefaultProfile() : specifiedProfiles;
        String label = StringUtils.isEmpty((Object)specifiedLabel) ? this.serverProperties.getDefaultLabel() : specifiedLabel;
        String[] profileArray = this.parseProfiles(profiles);
        Environment environment = new Environment(application, profileArray);
        environment.setLabel(label);
        for (String profile : profileArray) {
            S3ConfigFile s3ConfigFile = this.getS3ConfigFile(application, profile, label);
            if (s3ConfigFile == null) continue;
            environment.setVersion(s3ConfigFile.getVersion());
            Properties config = s3ConfigFile.read();
            config.putAll(this.serverProperties.getOverrides());
            StringBuilder propertySourceName = new StringBuilder().append("s3:").append(application);
            if (profile != null) {
                propertySourceName.append("-").append(profile);
            }
            environment.add(new PropertySource(propertySourceName.toString(), (Map)config));
        }
        return environment;
    }

    private String[] parseProfiles(String profiles) {
        if (profiles.equals(this.serverProperties.getDefaultProfile())) {
            return new String[]{profiles, null};
        }
        return StringUtils.commaDelimitedListToStringArray((String)profiles);
    }

    private S3ConfigFile getS3ConfigFile(String application, String profile, String label) {
        String objectKeyPrefix = this.buildObjectKeyPrefix(application, profile, label);
        S3ObjectIdBuilder s3ObjectIdBuilder = new S3ObjectIdBuilder().withBucket(this.bucketName);
        return this.getS3ConfigFile(s3ObjectIdBuilder, objectKeyPrefix);
    }

    private String buildObjectKeyPrefix(String application, String profile, String label) {
        StringBuilder objectKeyPrefix = new StringBuilder();
        if (!StringUtils.isEmpty((Object)label)) {
            objectKeyPrefix.append(label).append(PATH_SEPARATOR);
        }
        objectKeyPrefix.append(application);
        if (!StringUtils.isEmpty((Object)profile)) {
            objectKeyPrefix.append("-").append(profile);
        }
        return objectKeyPrefix.toString();
    }

    private S3ConfigFile getS3ConfigFile(S3ObjectIdBuilder s3ObjectIdBuilder, String keyPrefix) {
        try {
            S3Object properties = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".properties").build()));
            return new PropertyS3ConfigFile(properties.getObjectMetadata().getVersionId(), (InputStream)properties.getObjectContent());
        }
        catch (Exception eProperties) {
            try {
                S3Object yaml = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".yml").build()));
                return new YamlS3ConfigFile(yaml.getObjectMetadata().getVersionId(), (InputStream)yaml.getObjectContent());
            }
            catch (Exception eYaml) {
                try {
                    S3Object json = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".json").build()));
                    return new JsonS3ConfigFile(json.getObjectMetadata().getVersionId(), (InputStream)json.getObjectContent());
                }
                catch (Exception eJson) {
                    return null;
                }
            }
        }
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profiles, String label) {
        String baseLocation = AWS_S3_RESOURCE_SCHEME + this.bucketName + PATH_SEPARATOR + application;
        return new SearchPathLocator.Locations(application, profiles, label, null, new String[]{baseLocation});
    }
}

