/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.util.StringUtils;

public class HttpRequestConfigTokenProvider
implements ConfigTokenProvider {
    private ObjectProvider<HttpServletRequest> httpRequest;

    public HttpRequestConfigTokenProvider(ObjectProvider<HttpServletRequest> httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    public String getToken() {
        HttpServletRequest request = (HttpServletRequest)this.httpRequest.getIfAvailable();
        if (request == null) {
            throw new IllegalStateException("No HttpServletRequest available");
        }
        String token = request.getHeader("X-Config-Token");
        if (!StringUtils.hasLength((String)token)) {
            throw new IllegalArgumentException("Missing required header in HttpServletRequest: X-Config-Token");
        }
        return token;
    }
}

