/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.Optional;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.cloud.config.server.support.TransportConfigCallbackFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class MultipleJGitEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<MultipleJGitEnvironmentRepository, MultipleJGitEnvironmentProperties> {
    private ConfigurableEnvironment environment;
    private ConfigServerProperties server;
    private Optional<ConfigurableHttpConnectionFactory> connectionFactory;
    private final TransportConfigCallbackFactory transportConfigCallbackFactory;
    private final GitCredentialsProviderFactory gitCredentialsProviderFactory;

    @Deprecated
    public MultipleJGitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, TransportConfigCallbackFactory transportConfigCallbackFactory) {
        this(environment, server, Optional.empty(), transportConfigCallbackFactory, new GitCredentialsProviderFactory());
    }

    @Deprecated
    public MultipleJGitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<ConfigurableHttpConnectionFactory> connectionFactory, TransportConfigCallbackFactory transportConfigCallbackFactory) {
        this(environment, server, connectionFactory, transportConfigCallbackFactory, new GitCredentialsProviderFactory());
    }

    public MultipleJGitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<ConfigurableHttpConnectionFactory> connectionFactory, TransportConfigCallbackFactory transportConfigCallbackFactory, GitCredentialsProviderFactory gitCredentialsProviderFactory) {
        this.environment = environment;
        this.server = server;
        this.connectionFactory = connectionFactory;
        this.transportConfigCallbackFactory = transportConfigCallbackFactory;
        this.gitCredentialsProviderFactory = gitCredentialsProviderFactory;
    }

    @Override
    public MultipleJGitEnvironmentRepository build(MultipleJGitEnvironmentProperties environmentProperties) throws Exception {
        if (this.connectionFactory.isPresent()) {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)this.connectionFactory.get());
            this.connectionFactory.get().addConfiguration(environmentProperties);
        }
        MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository(this.environment, environmentProperties, ObservationRegistry.NOOP);
        repository.setTransportConfigCallback(this.transportConfigCallbackFactory.build(environmentProperties));
        if (this.server.getDefaultLabel() != null) {
            repository.setDefaultLabel(this.server.getDefaultLabel());
        }
        repository.setGitCredentialsProviderFactory(this.gitCredentialsProviderFactory);
        repository.getRepos().forEach((name, repo) -> repo.setGitCredentialsProviderFactory(this.gitCredentialsProviderFactory));
        return repository;
    }
}

