/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.config.server.config.RsaEncryptionAutoConfiguration;
import org.springframework.cloud.config.server.encryption.LocatorTextEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={RsaEncryptionAutoConfiguration.class})
@EnableConfigurationProperties
public class DefaultTextEncryptionAutoConfiguration {
    @Autowired
    ApplicationContext context;

    @Bean
    @ConditionalOnMissingBean
    public KeyProperties keyProperties() {
        return new KeyProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={TextEncryptor.class})
    @ConditionalOnBean(value={TextEncryptorLocator.class})
    public TextEncryptor defaultLocatorBasedTextEncryptor(TextEncryptorLocator locator) {
        return new LocatorTextEncryptor(locator);
    }

    @Bean
    @ConditionalOnMissingBean(value={TextEncryptor.class})
    public TextEncryptor defaultTextEncryptor(KeyProperties key) {
        if (StringUtils.hasText((String)key.getKey())) {
            return new EncryptorFactory(key.getSalt()).create(key.getKey());
        }
        return Encryptors.noOpText();
    }
}

