/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public abstract class PathUtils {
    private static final Log logger = LogFactory.getLog(PathUtils.class);

    private PathUtils() {
    }

    public static boolean isInvalidEncodedLocation(String location) {
        if (ObjectUtils.isEmpty((Object)location)) {
            return false;
        }
        if (location.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(location, "UTF-8");
                if (PathUtils.isInvalidLocation(decodedPath)) {
                    return true;
                }
                if (PathUtils.isInvalidLocation(decodedPath = PathUtils.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return PathUtils.isInvalidLocation(location);
    }

    private static boolean isInvalidLocation(String location) {
        boolean isInvalid = location.contains("..");
        if (isInvalid && logger.isWarnEnabled()) {
            logger.warn((Object)"Location contains \"..\"");
        }
        if (!isInvalid && (isInvalid = location.contains("#")) && logger.isWarnEnabled()) {
            logger.warn((Object)"Location contains \"#\"");
        }
        return isInvalid;
    }

    public static boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (PathUtils.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (PathUtils.isInvalidPath(decodedPath = PathUtils.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected static String processPath(String path) {
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        path = PathUtils.cleanDuplicateSlashes(path);
        return PathUtils.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i = 0; i < path.length(); ++i) {
            char curr = path.charAt(i);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private static String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i) : path.substring(i);
        }
        return slash ? "/" : "";
    }

    public static boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]"));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Path represents URL or has \"url:\" prefix: [" + path + "]"));
                }
                return true;
            }
        }
        if (path.contains("..") && StringUtils.cleanPath((String)path).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]"));
            }
            return true;
        }
        return false;
    }

    public static boolean checkResource(Resource resource, Resource location, List<Resource> allowedLocations) throws IOException {
        if (PathUtils.isResourceUnderLocation(resource, location)) {
            return true;
        }
        if (allowedLocations != null) {
            for (Resource current : allowedLocations) {
                if (!PathUtils.isResourceUnderLocation(resource, current)) continue;
                return true;
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Resource path \"" + location.getURI() + "\" was successfully resolved but resource \"" + resource.getURL() + "\" is neither under the current location \"" + location.getURL() + "\" nor under any of the allowed locations " + (allowedLocations != null ? allowedLocations : "[]")));
        }
        return false;
    }

    private static boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        String encodedLocationPath = locationPath.endsWith("/") ? locationPath.substring(0, locationPath.length() - 1) + URLEncoder.encode("/", "UTF-8") : locationPath;
        return (resourcePath.startsWith(locationPath) || resourcePath.startsWith(encodedLocationPath)) && !PathUtils.isInvalidEncodedPath(resourcePath);
    }
}

