/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder.config;

import com.ecwid.consul.v1.ConsulClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.binder.ConsulBinder;
import org.springframework.cloud.consul.binder.EventService;
import org.springframework.cloud.consul.binder.config.ConsulBinderProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@ConditionalOnConsulEnabled
@ConditionalOnProperty(name={"spring.cloud.consul.binder.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ConsulBinderProperties.class})
public class ConsulBinderConfiguration {
    @Autowired
    private ConsulBinderProperties consulBinderProperties;
    @Autowired(required=false)
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Bean
    @ConditionalOnMissingBean
    public EventService eventService(ConsulClient consulClient) {
        return new EventService(this.consulBinderProperties, consulClient, this.objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulBinder consulClientBinder(EventService eventService) {
        return new ConsulBinder(eventService);
    }
}

